// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about the permissions settings of the bucket policy for an S3 bucket.
 */
class BucketPolicy private constructor(builder: BuilderImpl) {
    /**
     * Specifies whether the bucket policy allows the general public to have read access to the bucket.
     */
    val allowsPublicReadAccess: Boolean? = builder.allowsPublicReadAccess
    /**
     * Specifies whether the bucket policy allows the general public to have write access to the bucket.
     */
    val allowsPublicWriteAccess: Boolean? = builder.allowsPublicWriteAccess

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): BucketPolicy = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("BucketPolicy(")
        append("allowsPublicReadAccess=$allowsPublicReadAccess,")
        append("allowsPublicWriteAccess=$allowsPublicWriteAccess)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowsPublicReadAccess?.hashCode() ?: 0
        result = 31 * result + (allowsPublicWriteAccess?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as BucketPolicy

        if (allowsPublicReadAccess != other.allowsPublicReadAccess) return false
        if (allowsPublicWriteAccess != other.allowsPublicWriteAccess) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): BucketPolicy = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): BucketPolicy
        /**
         * Specifies whether the bucket policy allows the general public to have read access to the bucket.
         */
        fun allowsPublicReadAccess(allowsPublicReadAccess: Boolean): FluentBuilder
        /**
         * Specifies whether the bucket policy allows the general public to have write access to the bucket.
         */
        fun allowsPublicWriteAccess(allowsPublicWriteAccess: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specifies whether the bucket policy allows the general public to have read access to the bucket.
         */
        var allowsPublicReadAccess: Boolean?
        /**
         * Specifies whether the bucket policy allows the general public to have write access to the bucket.
         */
        var allowsPublicWriteAccess: Boolean?

        fun build(): BucketPolicy
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var allowsPublicReadAccess: Boolean? = null
        override var allowsPublicWriteAccess: Boolean? = null

        constructor(x: BucketPolicy) : this() {
            this.allowsPublicReadAccess = x.allowsPublicReadAccess
            this.allowsPublicWriteAccess = x.allowsPublicWriteAccess
        }

        override fun build(): BucketPolicy = BucketPolicy(this)
        override fun allowsPublicReadAccess(allowsPublicReadAccess: Boolean): FluentBuilder = apply { this.allowsPublicReadAccess = allowsPublicReadAccess }
        override fun allowsPublicWriteAccess(allowsPublicWriteAccess: Boolean): FluentBuilder = apply { this.allowsPublicWriteAccess = allowsPublicWriteAccess }
    }
}
