// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about the permissions settings that determine whether an S3 bucket is publicly accessible.
 */
class BucketPublicAccess private constructor(builder: BuilderImpl) {
    /**
     * Specifies whether the bucket is publicly accessible due to the combination of permissions settings that apply to the bucket. Possible values are: NOT_PUBLIC - The bucket isn't publicly accessible. PUBLIC - The bucket is publicly accessible. UNKNOWN - Amazon Macie can't determine whether the bucket is publicly accessible.
     */
    val effectivePermission: EffectivePermission? = builder.effectivePermission
    /**
     * The account-level and bucket-level permissions settings for the bucket.
     */
    val permissionConfiguration: BucketPermissionConfiguration? = builder.permissionConfiguration

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): BucketPublicAccess = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("BucketPublicAccess(")
        append("effectivePermission=$effectivePermission,")
        append("permissionConfiguration=$permissionConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = effectivePermission?.hashCode() ?: 0
        result = 31 * result + (permissionConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as BucketPublicAccess

        if (effectivePermission != other.effectivePermission) return false
        if (permissionConfiguration != other.permissionConfiguration) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): BucketPublicAccess = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): BucketPublicAccess
        /**
         * Specifies whether the bucket is publicly accessible due to the combination of permissions settings that apply to the bucket. Possible values are: NOT_PUBLIC - The bucket isn't publicly accessible. PUBLIC - The bucket is publicly accessible. UNKNOWN - Amazon Macie can't determine whether the bucket is publicly accessible.
         */
        fun effectivePermission(effectivePermission: EffectivePermission): FluentBuilder
        /**
         * The account-level and bucket-level permissions settings for the bucket.
         */
        fun permissionConfiguration(permissionConfiguration: BucketPermissionConfiguration): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specifies whether the bucket is publicly accessible due to the combination of permissions settings that apply to the bucket. Possible values are: NOT_PUBLIC - The bucket isn't publicly accessible. PUBLIC - The bucket is publicly accessible. UNKNOWN - Amazon Macie can't determine whether the bucket is publicly accessible.
         */
        var effectivePermission: EffectivePermission?
        /**
         * The account-level and bucket-level permissions settings for the bucket.
         */
        var permissionConfiguration: BucketPermissionConfiguration?

        fun build(): BucketPublicAccess
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.BucketPermissionConfiguration] inside the given [block]
         */
        fun permissionConfiguration(block: BucketPermissionConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.permissionConfiguration = BucketPermissionConfiguration.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var effectivePermission: EffectivePermission? = null
        override var permissionConfiguration: BucketPermissionConfiguration? = null

        constructor(x: BucketPublicAccess) : this() {
            this.effectivePermission = x.effectivePermission
            this.permissionConfiguration = x.permissionConfiguration
        }

        override fun build(): BucketPublicAccess = BucketPublicAccess(this)
        override fun effectivePermission(effectivePermission: EffectivePermission): FluentBuilder = apply { this.effectivePermission = effectivePermission }
        override fun permissionConfiguration(permissionConfiguration: BucketPermissionConfiguration): FluentBuilder = apply { this.permissionConfiguration = permissionConfiguration }
    }
}
