// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about the default server-side encryption settings for an S3 bucket. For detailed information about these settings, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucket-encryption.html">Setting default server-side encryption behavior for Amazon S3 buckets in the Amazon Simple Storage Service User Guide.
 */
class BucketServerSideEncryption private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) or unique identifier (key ID) for the Key Management Service (KMS) customer master key (CMK) that's used by default to encrypt objects that are added to the bucket. This value is null if the bucket uses an Amazon S3 managed key to encrypt new objects or the bucket doesn't encrypt new objects by default.
     */
    val kmsMasterKeyId: String? = builder.kmsMasterKeyId
    /**
     * The type of server-side encryption that's used by default when storing new objects in the bucket. Possible values are: AES256 - New objects are encrypted with an Amazon S3 managed key and use Amazon S3 managed encryption (SSE-S3). aws:kms - New objects are encrypted with an KMS CMK, specified by the kmsMasterKeyId property, and use Amazon Web Services managed KMS encryption (AWS-KMS) or customer managed KMS encryption (SSE-KMS). NONE - New objects aren't encrypted by default. Default encryption is disabled for the bucket.
     */
    val type: Type? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): BucketServerSideEncryption = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("BucketServerSideEncryption(")
        append("kmsMasterKeyId=$kmsMasterKeyId,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsMasterKeyId?.hashCode() ?: 0
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as BucketServerSideEncryption

        if (kmsMasterKeyId != other.kmsMasterKeyId) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): BucketServerSideEncryption = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): BucketServerSideEncryption
        /**
         * The Amazon Resource Name (ARN) or unique identifier (key ID) for the Key Management Service (KMS) customer master key (CMK) that's used by default to encrypt objects that are added to the bucket. This value is null if the bucket uses an Amazon S3 managed key to encrypt new objects or the bucket doesn't encrypt new objects by default.
         */
        fun kmsMasterKeyId(kmsMasterKeyId: String): FluentBuilder
        /**
         * The type of server-side encryption that's used by default when storing new objects in the bucket. Possible values are: AES256 - New objects are encrypted with an Amazon S3 managed key and use Amazon S3 managed encryption (SSE-S3). aws:kms - New objects are encrypted with an KMS CMK, specified by the kmsMasterKeyId property, and use Amazon Web Services managed KMS encryption (AWS-KMS) or customer managed KMS encryption (SSE-KMS). NONE - New objects aren't encrypted by default. Default encryption is disabled for the bucket.
         */
        fun type(type: Type): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) or unique identifier (key ID) for the Key Management Service (KMS) customer master key (CMK) that's used by default to encrypt objects that are added to the bucket. This value is null if the bucket uses an Amazon S3 managed key to encrypt new objects or the bucket doesn't encrypt new objects by default.
         */
        var kmsMasterKeyId: String?
        /**
         * The type of server-side encryption that's used by default when storing new objects in the bucket. Possible values are: AES256 - New objects are encrypted with an Amazon S3 managed key and use Amazon S3 managed encryption (SSE-S3). aws:kms - New objects are encrypted with an KMS CMK, specified by the kmsMasterKeyId property, and use Amazon Web Services managed KMS encryption (AWS-KMS) or customer managed KMS encryption (SSE-KMS). NONE - New objects aren't encrypted by default. Default encryption is disabled for the bucket.
         */
        var type: Type?

        fun build(): BucketServerSideEncryption
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var kmsMasterKeyId: String? = null
        override var type: Type? = null

        constructor(x: BucketServerSideEncryption) : this() {
            this.kmsMasterKeyId = x.kmsMasterKeyId
            this.type = x.type
        }

        override fun build(): BucketServerSideEncryption = BucketServerSideEncryption(this)
        override fun kmsMasterKeyId(kmsMasterKeyId: String): FluentBuilder = apply { this.kmsMasterKeyId = kmsMasterKeyId }
        override fun type(type: Type): FluentBuilder = apply { this.type = type }
    }
}
