// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Specifies criteria for sorting the results of a query for information about S3 buckets.
 */
class BucketSortCriteria private constructor(builder: BuilderImpl) {
    /**
     * The name of the bucket property to sort the results by. This value can be one of the following properties that Amazon Macie defines as bucket metadata: accountId, bucketName, classifiableObjectCount, classifiableSizeInBytes, objectCount, or sizeInBytes.
     */
    val attributeName: String? = builder.attributeName
    /**
     * The sort order to apply to the results, based on the value specified by the attributeName property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.
     */
    val orderBy: OrderBy? = builder.orderBy

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): BucketSortCriteria = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("BucketSortCriteria(")
        append("attributeName=$attributeName,")
        append("orderBy=$orderBy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeName?.hashCode() ?: 0
        result = 31 * result + (orderBy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as BucketSortCriteria

        if (attributeName != other.attributeName) return false
        if (orderBy != other.orderBy) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): BucketSortCriteria = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): BucketSortCriteria
        /**
         * The name of the bucket property to sort the results by. This value can be one of the following properties that Amazon Macie defines as bucket metadata: accountId, bucketName, classifiableObjectCount, classifiableSizeInBytes, objectCount, or sizeInBytes.
         */
        fun attributeName(attributeName: String): FluentBuilder
        /**
         * The sort order to apply to the results, based on the value specified by the attributeName property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.
         */
        fun orderBy(orderBy: OrderBy): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the bucket property to sort the results by. This value can be one of the following properties that Amazon Macie defines as bucket metadata: accountId, bucketName, classifiableObjectCount, classifiableSizeInBytes, objectCount, or sizeInBytes.
         */
        var attributeName: String?
        /**
         * The sort order to apply to the results, based on the value specified by the attributeName property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.
         */
        var orderBy: OrderBy?

        fun build(): BucketSortCriteria
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var attributeName: String? = null
        override var orderBy: OrderBy? = null

        constructor(x: BucketSortCriteria) : this() {
            this.attributeName = x.attributeName
            this.orderBy = x.orderBy
        }

        override fun build(): BucketSortCriteria = BucketSortCriteria(this)
        override fun attributeName(attributeName: String): FluentBuilder = apply { this.attributeName = attributeName }
        override fun orderBy(orderBy: OrderBy): FluentBuilder = apply { this.orderBy = orderBy }
    }
}
