// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Specifies the location of an occurrence of sensitive data in a Microsoft Excel workbook, CSV file, or TSV file.
 */
class Cell private constructor(builder: BuilderImpl) {
    /**
     * The location of the cell, as an absolute cell reference, that contains the sensitive data, for example Sheet2!C5 for cell C5 on Sheet2 in a Microsoft Excel workbook. This value is null for CSV and TSV files.
     */
    val cellReference: String? = builder.cellReference
    /**
     * The column number of the column that contains the sensitive data. For a Microsoft Excel workbook, this value correlates to the alphabetical character(s) for a column identifier, for example: 1 for column A, 2 for column B, and so on.
     */
    val column: Long? = builder.column
    /**
     * The name of the column that contains the sensitive data, if available.
     */
    val columnName: String? = builder.columnName
    /**
     * The row number of the row that contains the sensitive data.
     */
    val row: Long? = builder.row

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Cell = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Cell(")
        append("cellReference=$cellReference,")
        append("column=$column,")
        append("columnName=$columnName,")
        append("row=$row)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cellReference?.hashCode() ?: 0
        result = 31 * result + (column?.hashCode() ?: 0)
        result = 31 * result + (columnName?.hashCode() ?: 0)
        result = 31 * result + (row?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Cell

        if (cellReference != other.cellReference) return false
        if (column != other.column) return false
        if (columnName != other.columnName) return false
        if (row != other.row) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Cell = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Cell
        /**
         * The location of the cell, as an absolute cell reference, that contains the sensitive data, for example Sheet2!C5 for cell C5 on Sheet2 in a Microsoft Excel workbook. This value is null for CSV and TSV files.
         */
        fun cellReference(cellReference: String): FluentBuilder
        /**
         * The column number of the column that contains the sensitive data. For a Microsoft Excel workbook, this value correlates to the alphabetical character(s) for a column identifier, for example: 1 for column A, 2 for column B, and so on.
         */
        fun column(column: Long): FluentBuilder
        /**
         * The name of the column that contains the sensitive data, if available.
         */
        fun columnName(columnName: String): FluentBuilder
        /**
         * The row number of the row that contains the sensitive data.
         */
        fun row(row: Long): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The location of the cell, as an absolute cell reference, that contains the sensitive data, for example Sheet2!C5 for cell C5 on Sheet2 in a Microsoft Excel workbook. This value is null for CSV and TSV files.
         */
        var cellReference: String?
        /**
         * The column number of the column that contains the sensitive data. For a Microsoft Excel workbook, this value correlates to the alphabetical character(s) for a column identifier, for example: 1 for column A, 2 for column B, and so on.
         */
        var column: Long?
        /**
         * The name of the column that contains the sensitive data, if available.
         */
        var columnName: String?
        /**
         * The row number of the row that contains the sensitive data.
         */
        var row: Long?

        fun build(): Cell
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var cellReference: String? = null
        override var column: Long? = null
        override var columnName: String? = null
        override var row: Long? = null

        constructor(x: Cell) : this() {
            this.cellReference = x.cellReference
            this.column = x.column
            this.columnName = x.columnName
            this.row = x.row
        }

        override fun build(): Cell = Cell(this)
        override fun cellReference(cellReference: String): FluentBuilder = apply { this.cellReference = cellReference }
        override fun column(column: Long): FluentBuilder = apply { this.column = column }
        override fun columnName(columnName: String): FluentBuilder = apply { this.columnName = columnName }
        override fun row(row: Long): FluentBuilder = apply { this.row = row }
    }
}
