// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about a sensitive data finding, including the classification job that produced the finding.
 */
class ClassificationDetails private constructor(builder: BuilderImpl) {
    /**
     * The path to the folder or file (in Amazon S3) that contains the corresponding sensitive data discovery result for the finding. If a finding applies to a large archive or compressed file, this value is the path to a folder. Otherwise, this value is the path to a file.
     */
    val detailedResultsLocation: String? = builder.detailedResultsLocation
    /**
     * The Amazon Resource Name (ARN) of the classification job that produced the finding.
     */
    val jobArn: String? = builder.jobArn
    /**
     * The unique identifier for the classification job that produced the finding.
     */
    val jobId: String? = builder.jobId
    /**
     * The status and other details of the finding.
     */
    val result: ClassificationResult? = builder.result

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ClassificationDetails = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ClassificationDetails(")
        append("detailedResultsLocation=$detailedResultsLocation,")
        append("jobArn=$jobArn,")
        append("jobId=$jobId,")
        append("result=$result)")
    }

    override fun hashCode(): kotlin.Int {
        var result = detailedResultsLocation?.hashCode() ?: 0
        result = 31 * result + (jobArn?.hashCode() ?: 0)
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (result?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ClassificationDetails

        if (detailedResultsLocation != other.detailedResultsLocation) return false
        if (jobArn != other.jobArn) return false
        if (jobId != other.jobId) return false
        if (result != other.result) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ClassificationDetails = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ClassificationDetails
        /**
         * The path to the folder or file (in Amazon S3) that contains the corresponding sensitive data discovery result for the finding. If a finding applies to a large archive or compressed file, this value is the path to a folder. Otherwise, this value is the path to a file.
         */
        fun detailedResultsLocation(detailedResultsLocation: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the classification job that produced the finding.
         */
        fun jobArn(jobArn: String): FluentBuilder
        /**
         * The unique identifier for the classification job that produced the finding.
         */
        fun jobId(jobId: String): FluentBuilder
        /**
         * The status and other details of the finding.
         */
        fun result(result: ClassificationResult): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The path to the folder or file (in Amazon S3) that contains the corresponding sensitive data discovery result for the finding. If a finding applies to a large archive or compressed file, this value is the path to a folder. Otherwise, this value is the path to a file.
         */
        var detailedResultsLocation: String?
        /**
         * The Amazon Resource Name (ARN) of the classification job that produced the finding.
         */
        var jobArn: String?
        /**
         * The unique identifier for the classification job that produced the finding.
         */
        var jobId: String?
        /**
         * The status and other details of the finding.
         */
        var result: ClassificationResult?

        fun build(): ClassificationDetails
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.ClassificationResult] inside the given [block]
         */
        fun result(block: ClassificationResult.DslBuilder.() -> kotlin.Unit) {
            this.result = ClassificationResult.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var detailedResultsLocation: String? = null
        override var jobArn: String? = null
        override var jobId: String? = null
        override var result: ClassificationResult? = null

        constructor(x: ClassificationDetails) : this() {
            this.detailedResultsLocation = x.detailedResultsLocation
            this.jobArn = x.jobArn
            this.jobId = x.jobId
            this.result = x.result
        }

        override fun build(): ClassificationDetails = ClassificationDetails(this)
        override fun detailedResultsLocation(detailedResultsLocation: String): FluentBuilder = apply { this.detailedResultsLocation = detailedResultsLocation }
        override fun jobArn(jobArn: String): FluentBuilder = apply { this.jobArn = jobArn }
        override fun jobId(jobId: String): FluentBuilder = apply { this.jobId = jobId }
        override fun result(result: ClassificationResult): FluentBuilder = apply { this.result = result }
    }
}
