// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides the details of a sensitive data finding, including the types, number of occurrences, and locations of the sensitive data that was detected.
 */
class ClassificationResult private constructor(builder: BuilderImpl) {
    /**
     * Specifies whether Amazon Macie detected additional occurrences of sensitive data in the S3 object. A finding includes location data for a maximum of 15 occurrences of sensitive data. This value can help you determine whether to investigate additional occurrences of sensitive data in an object. You can do this by referring to the corresponding sensitive data discovery result for the finding (ClassificationDetails.detailedResultsLocation).
     */
    val additionalOccurrences: Boolean? = builder.additionalOccurrences
    /**
     * The custom data identifiers that detected the sensitive data and the number of occurrences of the data that they detected.
     */
    val customDataIdentifiers: CustomDataIdentifiers? = builder.customDataIdentifiers
    /**
     * The type of content, as a MIME type, that the finding applies to. For example, application/gzip, for a GNU Gzip compressed archive file, or application/pdf, for an Adobe Portable Document Format file.
     */
    val mimeType: String? = builder.mimeType
    /**
     * The category, types, and number of occurrences of the sensitive data that produced the finding.
     */
    val sensitiveData: List<SensitiveDataItem>? = builder.sensitiveData
    /**
     * The total size, in bytes, of the data that the finding applies to.
     */
    val sizeClassified: Long? = builder.sizeClassified
    /**
     * The status of the finding.
     */
    val status: ClassificationResultStatus? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ClassificationResult = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ClassificationResult(")
        append("additionalOccurrences=$additionalOccurrences,")
        append("customDataIdentifiers=$customDataIdentifiers,")
        append("mimeType=$mimeType,")
        append("sensitiveData=$sensitiveData,")
        append("sizeClassified=$sizeClassified,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalOccurrences?.hashCode() ?: 0
        result = 31 * result + (customDataIdentifiers?.hashCode() ?: 0)
        result = 31 * result + (mimeType?.hashCode() ?: 0)
        result = 31 * result + (sensitiveData?.hashCode() ?: 0)
        result = 31 * result + (sizeClassified?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ClassificationResult

        if (additionalOccurrences != other.additionalOccurrences) return false
        if (customDataIdentifiers != other.customDataIdentifiers) return false
        if (mimeType != other.mimeType) return false
        if (sensitiveData != other.sensitiveData) return false
        if (sizeClassified != other.sizeClassified) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ClassificationResult = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ClassificationResult
        /**
         * Specifies whether Amazon Macie detected additional occurrences of sensitive data in the S3 object. A finding includes location data for a maximum of 15 occurrences of sensitive data. This value can help you determine whether to investigate additional occurrences of sensitive data in an object. You can do this by referring to the corresponding sensitive data discovery result for the finding (ClassificationDetails.detailedResultsLocation).
         */
        fun additionalOccurrences(additionalOccurrences: Boolean): FluentBuilder
        /**
         * The custom data identifiers that detected the sensitive data and the number of occurrences of the data that they detected.
         */
        fun customDataIdentifiers(customDataIdentifiers: CustomDataIdentifiers): FluentBuilder
        /**
         * The type of content, as a MIME type, that the finding applies to. For example, application/gzip, for a GNU Gzip compressed archive file, or application/pdf, for an Adobe Portable Document Format file.
         */
        fun mimeType(mimeType: String): FluentBuilder
        /**
         * The category, types, and number of occurrences of the sensitive data that produced the finding.
         */
        fun sensitiveData(sensitiveData: List<SensitiveDataItem>): FluentBuilder
        /**
         * The total size, in bytes, of the data that the finding applies to.
         */
        fun sizeClassified(sizeClassified: Long): FluentBuilder
        /**
         * The status of the finding.
         */
        fun status(status: ClassificationResultStatus): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specifies whether Amazon Macie detected additional occurrences of sensitive data in the S3 object. A finding includes location data for a maximum of 15 occurrences of sensitive data. This value can help you determine whether to investigate additional occurrences of sensitive data in an object. You can do this by referring to the corresponding sensitive data discovery result for the finding (ClassificationDetails.detailedResultsLocation).
         */
        var additionalOccurrences: Boolean?
        /**
         * The custom data identifiers that detected the sensitive data and the number of occurrences of the data that they detected.
         */
        var customDataIdentifiers: CustomDataIdentifiers?
        /**
         * The type of content, as a MIME type, that the finding applies to. For example, application/gzip, for a GNU Gzip compressed archive file, or application/pdf, for an Adobe Portable Document Format file.
         */
        var mimeType: String?
        /**
         * The category, types, and number of occurrences of the sensitive data that produced the finding.
         */
        var sensitiveData: List<SensitiveDataItem>?
        /**
         * The total size, in bytes, of the data that the finding applies to.
         */
        var sizeClassified: Long?
        /**
         * The status of the finding.
         */
        var status: ClassificationResultStatus?

        fun build(): ClassificationResult
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.CustomDataIdentifiers] inside the given [block]
         */
        fun customDataIdentifiers(block: CustomDataIdentifiers.DslBuilder.() -> kotlin.Unit) {
            this.customDataIdentifiers = CustomDataIdentifiers.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.ClassificationResultStatus] inside the given [block]
         */
        fun status(block: ClassificationResultStatus.DslBuilder.() -> kotlin.Unit) {
            this.status = ClassificationResultStatus.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var additionalOccurrences: Boolean? = null
        override var customDataIdentifiers: CustomDataIdentifiers? = null
        override var mimeType: String? = null
        override var sensitiveData: List<SensitiveDataItem>? = null
        override var sizeClassified: Long? = null
        override var status: ClassificationResultStatus? = null

        constructor(x: ClassificationResult) : this() {
            this.additionalOccurrences = x.additionalOccurrences
            this.customDataIdentifiers = x.customDataIdentifiers
            this.mimeType = x.mimeType
            this.sensitiveData = x.sensitiveData
            this.sizeClassified = x.sizeClassified
            this.status = x.status
        }

        override fun build(): ClassificationResult = ClassificationResult(this)
        override fun additionalOccurrences(additionalOccurrences: Boolean): FluentBuilder = apply { this.additionalOccurrences = additionalOccurrences }
        override fun customDataIdentifiers(customDataIdentifiers: CustomDataIdentifiers): FluentBuilder = apply { this.customDataIdentifiers = customDataIdentifiers }
        override fun mimeType(mimeType: String): FluentBuilder = apply { this.mimeType = mimeType }
        override fun sensitiveData(sensitiveData: List<SensitiveDataItem>): FluentBuilder = apply { this.sensitiveData = sensitiveData }
        override fun sizeClassified(sizeClassified: Long): FluentBuilder = apply { this.sizeClassified = sizeClassified }
        override fun status(status: ClassificationResultStatus): FluentBuilder = apply { this.status = status }
    }
}
