// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about the status of a sensitive data finding.
 */
class ClassificationResultStatus private constructor(builder: BuilderImpl) {
    /**
     * The status of the finding. Possible values are: COMPLETE - Amazon Macie successfully completed its analysis of the S3 object that the finding applies to. PARTIAL - Macie analyzed only a subset of the data in the S3 object that the finding applies to. For example, the object is an archive file that contains files in an unsupported format. SKIPPED - Macie wasn't able to analyze the S3 object that the finding applies to. For example, the object is a file in an unsupported format.
     */
    val code: String? = builder.code
    /**
     * A brief description of the status of the finding. Amazon Macie uses this value to notify you of any errors, warnings, or considerations that might impact your analysis of the finding.
     */
    val reason: String? = builder.reason

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ClassificationResultStatus = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ClassificationResultStatus(")
        append("code=$code,")
        append("reason=$reason)")
    }

    override fun hashCode(): kotlin.Int {
        var result = code?.hashCode() ?: 0
        result = 31 * result + (reason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ClassificationResultStatus

        if (code != other.code) return false
        if (reason != other.reason) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ClassificationResultStatus = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ClassificationResultStatus
        /**
         * The status of the finding. Possible values are: COMPLETE - Amazon Macie successfully completed its analysis of the S3 object that the finding applies to. PARTIAL - Macie analyzed only a subset of the data in the S3 object that the finding applies to. For example, the object is an archive file that contains files in an unsupported format. SKIPPED - Macie wasn't able to analyze the S3 object that the finding applies to. For example, the object is a file in an unsupported format.
         */
        fun code(code: String): FluentBuilder
        /**
         * A brief description of the status of the finding. Amazon Macie uses this value to notify you of any errors, warnings, or considerations that might impact your analysis of the finding.
         */
        fun reason(reason: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The status of the finding. Possible values are: COMPLETE - Amazon Macie successfully completed its analysis of the S3 object that the finding applies to. PARTIAL - Macie analyzed only a subset of the data in the S3 object that the finding applies to. For example, the object is an archive file that contains files in an unsupported format. SKIPPED - Macie wasn't able to analyze the S3 object that the finding applies to. For example, the object is a file in an unsupported format.
         */
        var code: String?
        /**
         * A brief description of the status of the finding. Amazon Macie uses this value to notify you of any errors, warnings, or considerations that might impact your analysis of the finding.
         */
        var reason: String?

        fun build(): ClassificationResultStatus
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var code: String? = null
        override var reason: String? = null

        constructor(x: ClassificationResultStatus) : this() {
            this.code = x.code
            this.reason = x.reason
        }

        override fun build(): ClassificationResultStatus = ClassificationResultStatus(this)
        override fun code(code: String): FluentBuilder = apply { this.code = code }
        override fun reason(reason: String): FluentBuilder = apply { this.reason = reason }
    }
}
