// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



class CreateClassificationJobRequest private constructor(builder: BuilderImpl) {
    /**
     * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The custom data identifiers to use for data analysis and classification.
     */
    val customDataIdentifierIds: List<String>? = builder.customDataIdentifierIds
    /**
     * A custom description of the job. The description can contain as many as 200 characters.
     */
    val description: String? = builder.description
    /**
     * Specifies whether to analyze all existing, eligible objects immediately after the job is created.
     */
    val initialRun: Boolean? = builder.initialRun
    /**
     * The schedule for running the job. Valid values are: ONE_TIME - Run the job only once. If you specify this value, don't specify a value for the scheduleFrequency property. SCHEDULED - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the scheduleFrequency property to define the recurrence pattern for the job.
     */
    val jobType: JobType? = builder.jobType
    /**
     * A custom name for the job. The name can contain as many as 500 characters.
     */
    val name: String? = builder.name
    /**
     * The S3 buckets that contain the objects to analyze, and the scope of that analysis.
     */
    val s3JobDefinition: S3JobDefinition? = builder.s3JobDefinition
    /**
     * The sampling depth, as a percentage, to apply when processing objects. This value determines the percentage of eligible objects that the job analyzes. If this value is less than 100, Amazon Macie selects the objects to analyze at random, up to the specified percentage, and analyzes all the data in those objects.
     */
    val samplingPercentage: Int? = builder.samplingPercentage
    /**
     * The recurrence pattern for running the job. To run the job only once, don't specify a value for this property and set the value for the jobType property to ONE_TIME.
     */
    val scheduleFrequency: JobScheduleFrequency? = builder.scheduleFrequency
    /**
     * A map of key-value pairs that specifies the tags to associate with the job. A job can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateClassificationJobRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateClassificationJobRequest(")
        append("clientToken=$clientToken,")
        append("customDataIdentifierIds=$customDataIdentifierIds,")
        append("description=$description,")
        append("initialRun=$initialRun,")
        append("jobType=$jobType,")
        append("name=$name,")
        append("s3JobDefinition=$s3JobDefinition,")
        append("samplingPercentage=$samplingPercentage,")
        append("scheduleFrequency=$scheduleFrequency,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (customDataIdentifierIds?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (initialRun?.hashCode() ?: 0)
        result = 31 * result + (jobType?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (s3JobDefinition?.hashCode() ?: 0)
        result = 31 * result + (samplingPercentage ?: 0)
        result = 31 * result + (scheduleFrequency?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateClassificationJobRequest

        if (clientToken != other.clientToken) return false
        if (customDataIdentifierIds != other.customDataIdentifierIds) return false
        if (description != other.description) return false
        if (initialRun != other.initialRun) return false
        if (jobType != other.jobType) return false
        if (name != other.name) return false
        if (s3JobDefinition != other.s3JobDefinition) return false
        if (samplingPercentage != other.samplingPercentage) return false
        if (scheduleFrequency != other.scheduleFrequency) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateClassificationJobRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateClassificationJobRequest
        /**
         * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The custom data identifiers to use for data analysis and classification.
         */
        fun customDataIdentifierIds(customDataIdentifierIds: List<String>): FluentBuilder
        /**
         * A custom description of the job. The description can contain as many as 200 characters.
         */
        fun description(description: String): FluentBuilder
        /**
         * Specifies whether to analyze all existing, eligible objects immediately after the job is created.
         */
        fun initialRun(initialRun: Boolean): FluentBuilder
        /**
         * The schedule for running the job. Valid values are: ONE_TIME - Run the job only once. If you specify this value, don't specify a value for the scheduleFrequency property. SCHEDULED - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the scheduleFrequency property to define the recurrence pattern for the job.
         */
        fun jobType(jobType: JobType): FluentBuilder
        /**
         * A custom name for the job. The name can contain as many as 500 characters.
         */
        fun name(name: String): FluentBuilder
        /**
         * The S3 buckets that contain the objects to analyze, and the scope of that analysis.
         */
        fun s3JobDefinition(s3JobDefinition: S3JobDefinition): FluentBuilder
        /**
         * The sampling depth, as a percentage, to apply when processing objects. This value determines the percentage of eligible objects that the job analyzes. If this value is less than 100, Amazon Macie selects the objects to analyze at random, up to the specified percentage, and analyzes all the data in those objects.
         */
        fun samplingPercentage(samplingPercentage: Int): FluentBuilder
        /**
         * The recurrence pattern for running the job. To run the job only once, don't specify a value for this property and set the value for the jobType property to ONE_TIME.
         */
        fun scheduleFrequency(scheduleFrequency: JobScheduleFrequency): FluentBuilder
        /**
         * A map of key-value pairs that specifies the tags to associate with the job. A job can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
         */
        var clientToken: String?
        /**
         * The custom data identifiers to use for data analysis and classification.
         */
        var customDataIdentifierIds: List<String>?
        /**
         * A custom description of the job. The description can contain as many as 200 characters.
         */
        var description: String?
        /**
         * Specifies whether to analyze all existing, eligible objects immediately after the job is created.
         */
        var initialRun: Boolean?
        /**
         * The schedule for running the job. Valid values are: ONE_TIME - Run the job only once. If you specify this value, don't specify a value for the scheduleFrequency property. SCHEDULED - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the scheduleFrequency property to define the recurrence pattern for the job.
         */
        var jobType: JobType?
        /**
         * A custom name for the job. The name can contain as many as 500 characters.
         */
        var name: String?
        /**
         * The S3 buckets that contain the objects to analyze, and the scope of that analysis.
         */
        var s3JobDefinition: S3JobDefinition?
        /**
         * The sampling depth, as a percentage, to apply when processing objects. This value determines the percentage of eligible objects that the job analyzes. If this value is less than 100, Amazon Macie selects the objects to analyze at random, up to the specified percentage, and analyzes all the data in those objects.
         */
        var samplingPercentage: Int?
        /**
         * The recurrence pattern for running the job. To run the job only once, don't specify a value for this property and set the value for the jobType property to ONE_TIME.
         */
        var scheduleFrequency: JobScheduleFrequency?
        /**
         * A map of key-value pairs that specifies the tags to associate with the job. A job can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
         */
        var tags: Map<String, String>?

        fun build(): CreateClassificationJobRequest
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.S3JobDefinition] inside the given [block]
         */
        fun s3JobDefinition(block: S3JobDefinition.DslBuilder.() -> kotlin.Unit) {
            this.s3JobDefinition = S3JobDefinition.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.JobScheduleFrequency] inside the given [block]
         */
        fun scheduleFrequency(block: JobScheduleFrequency.DslBuilder.() -> kotlin.Unit) {
            this.scheduleFrequency = JobScheduleFrequency.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var customDataIdentifierIds: List<String>? = null
        override var description: String? = null
        override var initialRun: Boolean? = null
        override var jobType: JobType? = null
        override var name: String? = null
        override var s3JobDefinition: S3JobDefinition? = null
        override var samplingPercentage: Int? = null
        override var scheduleFrequency: JobScheduleFrequency? = null
        override var tags: Map<String, String>? = null

        constructor(x: CreateClassificationJobRequest) : this() {
            this.clientToken = x.clientToken
            this.customDataIdentifierIds = x.customDataIdentifierIds
            this.description = x.description
            this.initialRun = x.initialRun
            this.jobType = x.jobType
            this.name = x.name
            this.s3JobDefinition = x.s3JobDefinition
            this.samplingPercentage = x.samplingPercentage
            this.scheduleFrequency = x.scheduleFrequency
            this.tags = x.tags
        }

        override fun build(): CreateClassificationJobRequest = CreateClassificationJobRequest(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun customDataIdentifierIds(customDataIdentifierIds: List<String>): FluentBuilder = apply { this.customDataIdentifierIds = customDataIdentifierIds }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun initialRun(initialRun: Boolean): FluentBuilder = apply { this.initialRun = initialRun }
        override fun jobType(jobType: JobType): FluentBuilder = apply { this.jobType = jobType }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun s3JobDefinition(s3JobDefinition: S3JobDefinition): FluentBuilder = apply { this.s3JobDefinition = s3JobDefinition }
        override fun samplingPercentage(samplingPercentage: Int): FluentBuilder = apply { this.samplingPercentage = samplingPercentage }
        override fun scheduleFrequency(scheduleFrequency: JobScheduleFrequency): FluentBuilder = apply { this.scheduleFrequency = scheduleFrequency }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
