// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



class CreateCustomDataIdentifierRequest private constructor(builder: BuilderImpl) {
    /**
     * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
     */
    val clientToken: String? = builder.clientToken
    /**
     * A custom description of the custom data identifier. The description can contain as many as 512 characters. We strongly recommend that you avoid including any sensitive data in the description of a custom data identifier. Other users of your account might be able to see the identifier's description, depending on the actions that they're allowed to perform in Amazon Macie.
     */
    val description: String? = builder.description
    /**
     * An array that lists specific character sequences (ignore words) to exclude from the results. If the text matched by the regular expression is the same as any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4-90 characters. Ignore words are case sensitive.
     */
    val ignoreWords: List<String>? = builder.ignoreWords
    /**
     * An array that lists specific character sequences (keywords), one of which must be within proximity (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3-90 characters. Keywords aren't case sensitive.
     */
    val keywords: List<String>? = builder.keywords
    /**
     * The maximum number of characters that can exist between text that matches the regex pattern and the character sequences specified by the keywords array. Macie includes or excludes a result based on the proximity of a keyword to text that matches the regex pattern. The distance can be 1-300 characters. The default value is 50.
     */
    val maximumMatchDistance: Int? = builder.maximumMatchDistance
    /**
     * A custom name for the custom data identifier. The name can contain as many as 128 characters. We strongly recommend that you avoid including any sensitive data in the name of a custom data identifier. Other users of your account might be able to see the identifier's name, depending on the actions that they're allowed to perform in Amazon Macie.
     */
    val name: String? = builder.name
    /**
     * The regular expression (regex) that defines the pattern to match. The expression can contain as many as 512 characters.
     */
    val regex: String? = builder.regex
    /**
     * A map of key-value pairs that specifies the tags to associate with the custom data identifier. A custom data identifier can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateCustomDataIdentifierRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateCustomDataIdentifierRequest(")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("ignoreWords=$ignoreWords,")
        append("keywords=$keywords,")
        append("maximumMatchDistance=$maximumMatchDistance,")
        append("name=$name,")
        append("regex=$regex,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (ignoreWords?.hashCode() ?: 0)
        result = 31 * result + (keywords?.hashCode() ?: 0)
        result = 31 * result + (maximumMatchDistance ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (regex?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateCustomDataIdentifierRequest

        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (ignoreWords != other.ignoreWords) return false
        if (keywords != other.keywords) return false
        if (maximumMatchDistance != other.maximumMatchDistance) return false
        if (name != other.name) return false
        if (regex != other.regex) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateCustomDataIdentifierRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateCustomDataIdentifierRequest
        /**
         * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * A custom description of the custom data identifier. The description can contain as many as 512 characters. We strongly recommend that you avoid including any sensitive data in the description of a custom data identifier. Other users of your account might be able to see the identifier's description, depending on the actions that they're allowed to perform in Amazon Macie.
         */
        fun description(description: String): FluentBuilder
        /**
         * An array that lists specific character sequences (ignore words) to exclude from the results. If the text matched by the regular expression is the same as any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4-90 characters. Ignore words are case sensitive.
         */
        fun ignoreWords(ignoreWords: List<String>): FluentBuilder
        /**
         * An array that lists specific character sequences (keywords), one of which must be within proximity (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3-90 characters. Keywords aren't case sensitive.
         */
        fun keywords(keywords: List<String>): FluentBuilder
        /**
         * The maximum number of characters that can exist between text that matches the regex pattern and the character sequences specified by the keywords array. Macie includes or excludes a result based on the proximity of a keyword to text that matches the regex pattern. The distance can be 1-300 characters. The default value is 50.
         */
        fun maximumMatchDistance(maximumMatchDistance: Int): FluentBuilder
        /**
         * A custom name for the custom data identifier. The name can contain as many as 128 characters. We strongly recommend that you avoid including any sensitive data in the name of a custom data identifier. Other users of your account might be able to see the identifier's name, depending on the actions that they're allowed to perform in Amazon Macie.
         */
        fun name(name: String): FluentBuilder
        /**
         * The regular expression (regex) that defines the pattern to match. The expression can contain as many as 512 characters.
         */
        fun regex(regex: String): FluentBuilder
        /**
         * A map of key-value pairs that specifies the tags to associate with the custom data identifier. A custom data identifier can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
         */
        var clientToken: String?
        /**
         * A custom description of the custom data identifier. The description can contain as many as 512 characters. We strongly recommend that you avoid including any sensitive data in the description of a custom data identifier. Other users of your account might be able to see the identifier's description, depending on the actions that they're allowed to perform in Amazon Macie.
         */
        var description: String?
        /**
         * An array that lists specific character sequences (ignore words) to exclude from the results. If the text matched by the regular expression is the same as any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4-90 characters. Ignore words are case sensitive.
         */
        var ignoreWords: List<String>?
        /**
         * An array that lists specific character sequences (keywords), one of which must be within proximity (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3-90 characters. Keywords aren't case sensitive.
         */
        var keywords: List<String>?
        /**
         * The maximum number of characters that can exist between text that matches the regex pattern and the character sequences specified by the keywords array. Macie includes or excludes a result based on the proximity of a keyword to text that matches the regex pattern. The distance can be 1-300 characters. The default value is 50.
         */
        var maximumMatchDistance: Int?
        /**
         * A custom name for the custom data identifier. The name can contain as many as 128 characters. We strongly recommend that you avoid including any sensitive data in the name of a custom data identifier. Other users of your account might be able to see the identifier's name, depending on the actions that they're allowed to perform in Amazon Macie.
         */
        var name: String?
        /**
         * The regular expression (regex) that defines the pattern to match. The expression can contain as many as 512 characters.
         */
        var regex: String?
        /**
         * A map of key-value pairs that specifies the tags to associate with the custom data identifier. A custom data identifier can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
         */
        var tags: Map<String, String>?

        fun build(): CreateCustomDataIdentifierRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var description: String? = null
        override var ignoreWords: List<String>? = null
        override var keywords: List<String>? = null
        override var maximumMatchDistance: Int? = null
        override var name: String? = null
        override var regex: String? = null
        override var tags: Map<String, String>? = null

        constructor(x: CreateCustomDataIdentifierRequest) : this() {
            this.clientToken = x.clientToken
            this.description = x.description
            this.ignoreWords = x.ignoreWords
            this.keywords = x.keywords
            this.maximumMatchDistance = x.maximumMatchDistance
            this.name = x.name
            this.regex = x.regex
            this.tags = x.tags
        }

        override fun build(): CreateCustomDataIdentifierRequest = CreateCustomDataIdentifierRequest(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun ignoreWords(ignoreWords: List<String>): FluentBuilder = apply { this.ignoreWords = ignoreWords }
        override fun keywords(keywords: List<String>): FluentBuilder = apply { this.keywords = keywords }
        override fun maximumMatchDistance(maximumMatchDistance: Int): FluentBuilder = apply { this.maximumMatchDistance = maximumMatchDistance }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun regex(regex: String): FluentBuilder = apply { this.regex = regex }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
