// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



class CreateFindingsFilterRequest private constructor(builder: BuilderImpl) {
    /**
     * The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.
     */
    val action: FindingsFilterAction? = builder.action
    /**
     * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
     */
    val clientToken: String? = builder.clientToken
    /**
     * A custom description of the filter. The description can contain as many as 512 characters. We strongly recommend that you avoid including any sensitive data in the description of a filter. Other users of your account might be able to see the filter's description, depending on the actions that they're allowed to perform in Amazon Macie.
     */
    val description: String? = builder.description
    /**
     * The criteria to use to filter findings.
     */
    val findingCriteria: FindingCriteria? = builder.findingCriteria
    /**
     * A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters. We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users of your account might be able to see the filter's name, depending on the actions that they're allowed to perform in Amazon Macie.
     */
    val name: String? = builder.name
    /**
     * The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.
     */
    val position: Int? = builder.position
    /**
     * A map of key-value pairs that specifies the tags to associate with the filter. A findings filter can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateFindingsFilterRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFindingsFilterRequest(")
        append("action=$action,")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("findingCriteria=$findingCriteria,")
        append("name=$name,")
        append("position=$position,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (findingCriteria?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (position ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateFindingsFilterRequest

        if (action != other.action) return false
        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (findingCriteria != other.findingCriteria) return false
        if (name != other.name) return false
        if (position != other.position) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateFindingsFilterRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateFindingsFilterRequest
        /**
         * The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.
         */
        fun action(action: FindingsFilterAction): FluentBuilder
        /**
         * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * A custom description of the filter. The description can contain as many as 512 characters. We strongly recommend that you avoid including any sensitive data in the description of a filter. Other users of your account might be able to see the filter's description, depending on the actions that they're allowed to perform in Amazon Macie.
         */
        fun description(description: String): FluentBuilder
        /**
         * The criteria to use to filter findings.
         */
        fun findingCriteria(findingCriteria: FindingCriteria): FluentBuilder
        /**
         * A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters. We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users of your account might be able to see the filter's name, depending on the actions that they're allowed to perform in Amazon Macie.
         */
        fun name(name: String): FluentBuilder
        /**
         * The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.
         */
        fun position(position: Int): FluentBuilder
        /**
         * A map of key-value pairs that specifies the tags to associate with the filter. A findings filter can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.
         */
        var action: FindingsFilterAction?
        /**
         * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
         */
        var clientToken: String?
        /**
         * A custom description of the filter. The description can contain as many as 512 characters. We strongly recommend that you avoid including any sensitive data in the description of a filter. Other users of your account might be able to see the filter's description, depending on the actions that they're allowed to perform in Amazon Macie.
         */
        var description: String?
        /**
         * The criteria to use to filter findings.
         */
        var findingCriteria: FindingCriteria?
        /**
         * A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters. We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users of your account might be able to see the filter's name, depending on the actions that they're allowed to perform in Amazon Macie.
         */
        var name: String?
        /**
         * The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.
         */
        var position: Int?
        /**
         * A map of key-value pairs that specifies the tags to associate with the filter. A findings filter can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
         */
        var tags: Map<String, String>?

        fun build(): CreateFindingsFilterRequest
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.FindingCriteria] inside the given [block]
         */
        fun findingCriteria(block: FindingCriteria.DslBuilder.() -> kotlin.Unit) {
            this.findingCriteria = FindingCriteria.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var action: FindingsFilterAction? = null
        override var clientToken: String? = null
        override var description: String? = null
        override var findingCriteria: FindingCriteria? = null
        override var name: String? = null
        override var position: Int? = null
        override var tags: Map<String, String>? = null

        constructor(x: CreateFindingsFilterRequest) : this() {
            this.action = x.action
            this.clientToken = x.clientToken
            this.description = x.description
            this.findingCriteria = x.findingCriteria
            this.name = x.name
            this.position = x.position
            this.tags = x.tags
        }

        override fun build(): CreateFindingsFilterRequest = CreateFindingsFilterRequest(this)
        override fun action(action: FindingsFilterAction): FluentBuilder = apply { this.action = action }
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun findingCriteria(findingCriteria: FindingCriteria): FluentBuilder = apply { this.findingCriteria = findingCriteria }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun position(position: Int): FluentBuilder = apply { this.position = position }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
