// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about custom data identifiers that produced a sensitive data finding, and the number of occurrences of the data that they detected for the finding.
 */
class CustomDataIdentifiers private constructor(builder: BuilderImpl) {
    /**
     * The custom data identifiers that detected the data, and the number of occurrences of the data that each identifier detected.
     */
    val detections: List<CustomDetection>? = builder.detections
    /**
     * The total number of occurrences of the data that was detected by the custom data identifiers and produced the finding.
     */
    val totalCount: Long? = builder.totalCount

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CustomDataIdentifiers = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CustomDataIdentifiers(")
        append("detections=$detections,")
        append("totalCount=$totalCount)")
    }

    override fun hashCode(): kotlin.Int {
        var result = detections?.hashCode() ?: 0
        result = 31 * result + (totalCount?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CustomDataIdentifiers

        if (detections != other.detections) return false
        if (totalCount != other.totalCount) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CustomDataIdentifiers = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CustomDataIdentifiers
        /**
         * The custom data identifiers that detected the data, and the number of occurrences of the data that each identifier detected.
         */
        fun detections(detections: List<CustomDetection>): FluentBuilder
        /**
         * The total number of occurrences of the data that was detected by the custom data identifiers and produced the finding.
         */
        fun totalCount(totalCount: Long): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The custom data identifiers that detected the data, and the number of occurrences of the data that each identifier detected.
         */
        var detections: List<CustomDetection>?
        /**
         * The total number of occurrences of the data that was detected by the custom data identifiers and produced the finding.
         */
        var totalCount: Long?

        fun build(): CustomDataIdentifiers
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var detections: List<CustomDetection>? = null
        override var totalCount: Long? = null

        constructor(x: CustomDataIdentifiers) : this() {
            this.detections = x.detections
            this.totalCount = x.totalCount
        }

        override fun build(): CustomDataIdentifiers = CustomDataIdentifiers(this)
        override fun detections(detections: List<CustomDetection>): FluentBuilder = apply { this.detections = detections }
        override fun totalCount(totalCount: Long): FluentBuilder = apply { this.totalCount = totalCount }
    }
}
