// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about a custom data identifier that produced a sensitive data finding, and the sensitive data that it detected for the finding.
 */
class CustomDetection private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the custom data identifier.
     */
    val arn: String? = builder.arn
    /**
     * The total number of occurrences of the sensitive data that the custom data identifier detected.
     */
    val count: Long? = builder.count
    /**
     * The name of the custom data identifier.
     */
    val name: String? = builder.name
    /**
     * The location of 1-15 occurrences of the sensitive data that the custom data identifier detected. A finding includes location data for a maximum of 15 occurrences of sensitive data.
     */
    val occurrences: Occurrences? = builder.occurrences

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CustomDetection = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CustomDetection(")
        append("arn=$arn,")
        append("count=$count,")
        append("name=$name,")
        append("occurrences=$occurrences)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (count?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (occurrences?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CustomDetection

        if (arn != other.arn) return false
        if (count != other.count) return false
        if (name != other.name) return false
        if (occurrences != other.occurrences) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CustomDetection = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CustomDetection
        /**
         * The Amazon Resource Name (ARN) of the custom data identifier.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The total number of occurrences of the sensitive data that the custom data identifier detected.
         */
        fun count(count: Long): FluentBuilder
        /**
         * The name of the custom data identifier.
         */
        fun name(name: String): FluentBuilder
        /**
         * The location of 1-15 occurrences of the sensitive data that the custom data identifier detected. A finding includes location data for a maximum of 15 occurrences of sensitive data.
         */
        fun occurrences(occurrences: Occurrences): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the custom data identifier.
         */
        var arn: String?
        /**
         * The total number of occurrences of the sensitive data that the custom data identifier detected.
         */
        var count: Long?
        /**
         * The name of the custom data identifier.
         */
        var name: String?
        /**
         * The location of 1-15 occurrences of the sensitive data that the custom data identifier detected. A finding includes location data for a maximum of 15 occurrences of sensitive data.
         */
        var occurrences: Occurrences?

        fun build(): CustomDetection
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.Occurrences] inside the given [block]
         */
        fun occurrences(block: Occurrences.DslBuilder.() -> kotlin.Unit) {
            this.occurrences = Occurrences.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var count: Long? = null
        override var name: String? = null
        override var occurrences: Occurrences? = null

        constructor(x: CustomDetection) : this() {
            this.arn = x.arn
            this.count = x.count
            this.name = x.name
            this.occurrences = x.occurrences
        }

        override fun build(): CustomDetection = CustomDetection(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun count(count: Long): FluentBuilder = apply { this.count = count }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun occurrences(occurrences: Occurrences): FluentBuilder = apply { this.occurrences = occurrences }
    }
}
