// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model

import aws.smithy.kotlin.runtime.time.Instant

class DescribeClassificationJobResponse private constructor(builder: BuilderImpl) {
    /**
     * The token that was provided to ensure the idempotency of the request to create the job.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The date and time, in UTC and extended ISO 8601 format, when the job was created.
     */
    val createdAt: Instant? = builder.createdAt
    /**
     * The custom data identifiers that the job uses to analyze data.
     */
    val customDataIdentifierIds: List<String>? = builder.customDataIdentifierIds
    /**
     * The custom description of the job.
     */
    val description: String? = builder.description
    /**
     * Specifies whether the job is configured to analyze all existing, eligible objects immediately after it's created.
     */
    val initialRun: Boolean? = builder.initialRun
    /**
     * The Amazon Resource Name (ARN) of the job.
     */
    val jobArn: String? = builder.jobArn
    /**
     * The unique identifier for the job.
     */
    val jobId: String? = builder.jobId
    /**
     * The current status of the job. Possible values are: CANCELLED - You cancelled the job or, if it's a one-time job, you paused the job and didn't resume it within 30 days. COMPLETE - For a one-time job, Amazon Macie finished processing the data specified for the job. This value doesn't apply to recurring jobs. IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is pending. This value doesn't apply to one-time jobs. PAUSED - Amazon Macie started running the job but additional processing would exceed the monthly sensitive data discovery quota for your account or one or more member accounts that the job analyzes data for. RUNNING - For a one-time job, the job is in progress. For a recurring job, a scheduled run is in progress. USER_PAUSED - You paused the job. If you paused the job while it had a status of RUNNING and you don't resume it within 30 days of pausing it, the job or job run will expire and be cancelled, depending on the job's type. To check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.
     */
    val jobStatus: JobStatus? = builder.jobStatus
    /**
     * The schedule for running the job. Possible values are: ONE_TIME - The job runs only once. SCHEDULED - The job runs on a daily, weekly, or monthly basis. The scheduleFrequency property indicates the recurrence pattern for the job.
     */
    val jobType: JobType? = builder.jobType
    /**
     * Specifies whether any account- or bucket-level access errors occurred when the job ran. For a recurring job, this value indicates the error status of the job's most recent run.
     */
    val lastRunErrorStatus: LastRunErrorStatus? = builder.lastRunErrorStatus
    /**
     * The date and time, in UTC and extended ISO 8601 format, when the job started. If the job is a recurring job, this value indicates when the most recent run started.
     */
    val lastRunTime: Instant? = builder.lastRunTime
    /**
     * The custom name of the job.
     */
    val name: String? = builder.name
    /**
     * The S3 buckets that contain the objects to analyze, and the scope of that analysis.
     */
    val s3JobDefinition: S3JobDefinition? = builder.s3JobDefinition
    /**
     * The sampling depth, as a percentage, that determines the percentage of eligible objects that the job analyzes.
     */
    val samplingPercentage: Int? = builder.samplingPercentage
    /**
     * The recurrence pattern for running the job. If the job is configured to run only once, this value is null.
     */
    val scheduleFrequency: JobScheduleFrequency? = builder.scheduleFrequency
    /**
     * The number of times that the job has run and processing statistics for the job's current run.
     */
    val statistics: Statistics? = builder.statistics
    /**
     * A map of key-value pairs that specifies which tags (keys and values) are associated with the classification job.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * If the current status of the job is USER_PAUSED, specifies when the job was paused and when the job or job run will expire and be cancelled if it isn't resumed. This value is present only if the value for jobStatus is USER_PAUSED.
     */
    val userPausedDetails: UserPausedDetails? = builder.userPausedDetails

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeClassificationJobResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeClassificationJobResponse(")
        append("clientToken=$clientToken,")
        append("createdAt=$createdAt,")
        append("customDataIdentifierIds=$customDataIdentifierIds,")
        append("description=$description,")
        append("initialRun=$initialRun,")
        append("jobArn=$jobArn,")
        append("jobId=$jobId,")
        append("jobStatus=$jobStatus,")
        append("jobType=$jobType,")
        append("lastRunErrorStatus=$lastRunErrorStatus,")
        append("lastRunTime=$lastRunTime,")
        append("name=$name,")
        append("s3JobDefinition=$s3JobDefinition,")
        append("samplingPercentage=$samplingPercentage,")
        append("scheduleFrequency=$scheduleFrequency,")
        append("statistics=$statistics,")
        append("tags=$tags,")
        append("userPausedDetails=$userPausedDetails)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (customDataIdentifierIds?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (initialRun?.hashCode() ?: 0)
        result = 31 * result + (jobArn?.hashCode() ?: 0)
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (jobStatus?.hashCode() ?: 0)
        result = 31 * result + (jobType?.hashCode() ?: 0)
        result = 31 * result + (lastRunErrorStatus?.hashCode() ?: 0)
        result = 31 * result + (lastRunTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (s3JobDefinition?.hashCode() ?: 0)
        result = 31 * result + (samplingPercentage ?: 0)
        result = 31 * result + (scheduleFrequency?.hashCode() ?: 0)
        result = 31 * result + (statistics?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (userPausedDetails?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeClassificationJobResponse

        if (clientToken != other.clientToken) return false
        if (createdAt != other.createdAt) return false
        if (customDataIdentifierIds != other.customDataIdentifierIds) return false
        if (description != other.description) return false
        if (initialRun != other.initialRun) return false
        if (jobArn != other.jobArn) return false
        if (jobId != other.jobId) return false
        if (jobStatus != other.jobStatus) return false
        if (jobType != other.jobType) return false
        if (lastRunErrorStatus != other.lastRunErrorStatus) return false
        if (lastRunTime != other.lastRunTime) return false
        if (name != other.name) return false
        if (s3JobDefinition != other.s3JobDefinition) return false
        if (samplingPercentage != other.samplingPercentage) return false
        if (scheduleFrequency != other.scheduleFrequency) return false
        if (statistics != other.statistics) return false
        if (tags != other.tags) return false
        if (userPausedDetails != other.userPausedDetails) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeClassificationJobResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeClassificationJobResponse
        /**
         * The token that was provided to ensure the idempotency of the request to create the job.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the job was created.
         */
        fun createdAt(createdAt: Instant): FluentBuilder
        /**
         * The custom data identifiers that the job uses to analyze data.
         */
        fun customDataIdentifierIds(customDataIdentifierIds: List<String>): FluentBuilder
        /**
         * The custom description of the job.
         */
        fun description(description: String): FluentBuilder
        /**
         * Specifies whether the job is configured to analyze all existing, eligible objects immediately after it's created.
         */
        fun initialRun(initialRun: Boolean): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the job.
         */
        fun jobArn(jobArn: String): FluentBuilder
        /**
         * The unique identifier for the job.
         */
        fun jobId(jobId: String): FluentBuilder
        /**
         * The current status of the job. Possible values are: CANCELLED - You cancelled the job or, if it's a one-time job, you paused the job and didn't resume it within 30 days. COMPLETE - For a one-time job, Amazon Macie finished processing the data specified for the job. This value doesn't apply to recurring jobs. IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is pending. This value doesn't apply to one-time jobs. PAUSED - Amazon Macie started running the job but additional processing would exceed the monthly sensitive data discovery quota for your account or one or more member accounts that the job analyzes data for. RUNNING - For a one-time job, the job is in progress. For a recurring job, a scheduled run is in progress. USER_PAUSED - You paused the job. If you paused the job while it had a status of RUNNING and you don't resume it within 30 days of pausing it, the job or job run will expire and be cancelled, depending on the job's type. To check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.
         */
        fun jobStatus(jobStatus: JobStatus): FluentBuilder
        /**
         * The schedule for running the job. Possible values are: ONE_TIME - The job runs only once. SCHEDULED - The job runs on a daily, weekly, or monthly basis. The scheduleFrequency property indicates the recurrence pattern for the job.
         */
        fun jobType(jobType: JobType): FluentBuilder
        /**
         * Specifies whether any account- or bucket-level access errors occurred when the job ran. For a recurring job, this value indicates the error status of the job's most recent run.
         */
        fun lastRunErrorStatus(lastRunErrorStatus: LastRunErrorStatus): FluentBuilder
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the job started. If the job is a recurring job, this value indicates when the most recent run started.
         */
        fun lastRunTime(lastRunTime: Instant): FluentBuilder
        /**
         * The custom name of the job.
         */
        fun name(name: String): FluentBuilder
        /**
         * The S3 buckets that contain the objects to analyze, and the scope of that analysis.
         */
        fun s3JobDefinition(s3JobDefinition: S3JobDefinition): FluentBuilder
        /**
         * The sampling depth, as a percentage, that determines the percentage of eligible objects that the job analyzes.
         */
        fun samplingPercentage(samplingPercentage: Int): FluentBuilder
        /**
         * The recurrence pattern for running the job. If the job is configured to run only once, this value is null.
         */
        fun scheduleFrequency(scheduleFrequency: JobScheduleFrequency): FluentBuilder
        /**
         * The number of times that the job has run and processing statistics for the job's current run.
         */
        fun statistics(statistics: Statistics): FluentBuilder
        /**
         * A map of key-value pairs that specifies which tags (keys and values) are associated with the classification job.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * If the current status of the job is USER_PAUSED, specifies when the job was paused and when the job or job run will expire and be cancelled if it isn't resumed. This value is present only if the value for jobStatus is USER_PAUSED.
         */
        fun userPausedDetails(userPausedDetails: UserPausedDetails): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The token that was provided to ensure the idempotency of the request to create the job.
         */
        var clientToken: String?
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the job was created.
         */
        var createdAt: Instant?
        /**
         * The custom data identifiers that the job uses to analyze data.
         */
        var customDataIdentifierIds: List<String>?
        /**
         * The custom description of the job.
         */
        var description: String?
        /**
         * Specifies whether the job is configured to analyze all existing, eligible objects immediately after it's created.
         */
        var initialRun: Boolean?
        /**
         * The Amazon Resource Name (ARN) of the job.
         */
        var jobArn: String?
        /**
         * The unique identifier for the job.
         */
        var jobId: String?
        /**
         * The current status of the job. Possible values are: CANCELLED - You cancelled the job or, if it's a one-time job, you paused the job and didn't resume it within 30 days. COMPLETE - For a one-time job, Amazon Macie finished processing the data specified for the job. This value doesn't apply to recurring jobs. IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is pending. This value doesn't apply to one-time jobs. PAUSED - Amazon Macie started running the job but additional processing would exceed the monthly sensitive data discovery quota for your account or one or more member accounts that the job analyzes data for. RUNNING - For a one-time job, the job is in progress. For a recurring job, a scheduled run is in progress. USER_PAUSED - You paused the job. If you paused the job while it had a status of RUNNING and you don't resume it within 30 days of pausing it, the job or job run will expire and be cancelled, depending on the job's type. To check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.
         */
        var jobStatus: JobStatus?
        /**
         * The schedule for running the job. Possible values are: ONE_TIME - The job runs only once. SCHEDULED - The job runs on a daily, weekly, or monthly basis. The scheduleFrequency property indicates the recurrence pattern for the job.
         */
        var jobType: JobType?
        /**
         * Specifies whether any account- or bucket-level access errors occurred when the job ran. For a recurring job, this value indicates the error status of the job's most recent run.
         */
        var lastRunErrorStatus: LastRunErrorStatus?
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the job started. If the job is a recurring job, this value indicates when the most recent run started.
         */
        var lastRunTime: Instant?
        /**
         * The custom name of the job.
         */
        var name: String?
        /**
         * The S3 buckets that contain the objects to analyze, and the scope of that analysis.
         */
        var s3JobDefinition: S3JobDefinition?
        /**
         * The sampling depth, as a percentage, that determines the percentage of eligible objects that the job analyzes.
         */
        var samplingPercentage: Int?
        /**
         * The recurrence pattern for running the job. If the job is configured to run only once, this value is null.
         */
        var scheduleFrequency: JobScheduleFrequency?
        /**
         * The number of times that the job has run and processing statistics for the job's current run.
         */
        var statistics: Statistics?
        /**
         * A map of key-value pairs that specifies which tags (keys and values) are associated with the classification job.
         */
        var tags: Map<String, String>?
        /**
         * If the current status of the job is USER_PAUSED, specifies when the job was paused and when the job or job run will expire and be cancelled if it isn't resumed. This value is present only if the value for jobStatus is USER_PAUSED.
         */
        var userPausedDetails: UserPausedDetails?

        fun build(): DescribeClassificationJobResponse
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.LastRunErrorStatus] inside the given [block]
         */
        fun lastRunErrorStatus(block: LastRunErrorStatus.DslBuilder.() -> kotlin.Unit) {
            this.lastRunErrorStatus = LastRunErrorStatus.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.S3JobDefinition] inside the given [block]
         */
        fun s3JobDefinition(block: S3JobDefinition.DslBuilder.() -> kotlin.Unit) {
            this.s3JobDefinition = S3JobDefinition.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.JobScheduleFrequency] inside the given [block]
         */
        fun scheduleFrequency(block: JobScheduleFrequency.DslBuilder.() -> kotlin.Unit) {
            this.scheduleFrequency = JobScheduleFrequency.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.Statistics] inside the given [block]
         */
        fun statistics(block: Statistics.DslBuilder.() -> kotlin.Unit) {
            this.statistics = Statistics.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.UserPausedDetails] inside the given [block]
         */
        fun userPausedDetails(block: UserPausedDetails.DslBuilder.() -> kotlin.Unit) {
            this.userPausedDetails = UserPausedDetails.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var createdAt: Instant? = null
        override var customDataIdentifierIds: List<String>? = null
        override var description: String? = null
        override var initialRun: Boolean? = null
        override var jobArn: String? = null
        override var jobId: String? = null
        override var jobStatus: JobStatus? = null
        override var jobType: JobType? = null
        override var lastRunErrorStatus: LastRunErrorStatus? = null
        override var lastRunTime: Instant? = null
        override var name: String? = null
        override var s3JobDefinition: S3JobDefinition? = null
        override var samplingPercentage: Int? = null
        override var scheduleFrequency: JobScheduleFrequency? = null
        override var statistics: Statistics? = null
        override var tags: Map<String, String>? = null
        override var userPausedDetails: UserPausedDetails? = null

        constructor(x: DescribeClassificationJobResponse) : this() {
            this.clientToken = x.clientToken
            this.createdAt = x.createdAt
            this.customDataIdentifierIds = x.customDataIdentifierIds
            this.description = x.description
            this.initialRun = x.initialRun
            this.jobArn = x.jobArn
            this.jobId = x.jobId
            this.jobStatus = x.jobStatus
            this.jobType = x.jobType
            this.lastRunErrorStatus = x.lastRunErrorStatus
            this.lastRunTime = x.lastRunTime
            this.name = x.name
            this.s3JobDefinition = x.s3JobDefinition
            this.samplingPercentage = x.samplingPercentage
            this.scheduleFrequency = x.scheduleFrequency
            this.statistics = x.statistics
            this.tags = x.tags
            this.userPausedDetails = x.userPausedDetails
        }

        override fun build(): DescribeClassificationJobResponse = DescribeClassificationJobResponse(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun createdAt(createdAt: Instant): FluentBuilder = apply { this.createdAt = createdAt }
        override fun customDataIdentifierIds(customDataIdentifierIds: List<String>): FluentBuilder = apply { this.customDataIdentifierIds = customDataIdentifierIds }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun initialRun(initialRun: Boolean): FluentBuilder = apply { this.initialRun = initialRun }
        override fun jobArn(jobArn: String): FluentBuilder = apply { this.jobArn = jobArn }
        override fun jobId(jobId: String): FluentBuilder = apply { this.jobId = jobId }
        override fun jobStatus(jobStatus: JobStatus): FluentBuilder = apply { this.jobStatus = jobStatus }
        override fun jobType(jobType: JobType): FluentBuilder = apply { this.jobType = jobType }
        override fun lastRunErrorStatus(lastRunErrorStatus: LastRunErrorStatus): FluentBuilder = apply { this.lastRunErrorStatus = lastRunErrorStatus }
        override fun lastRunTime(lastRunTime: Instant): FluentBuilder = apply { this.lastRunTime = lastRunTime }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun s3JobDefinition(s3JobDefinition: S3JobDefinition): FluentBuilder = apply { this.s3JobDefinition = s3JobDefinition }
        override fun samplingPercentage(samplingPercentage: Int): FluentBuilder = apply { this.samplingPercentage = samplingPercentage }
        override fun scheduleFrequency(scheduleFrequency: JobScheduleFrequency): FluentBuilder = apply { this.scheduleFrequency = scheduleFrequency }
        override fun statistics(statistics: Statistics): FluentBuilder = apply { this.statistics = statistics }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun userPausedDetails(userPausedDetails: UserPausedDetails): FluentBuilder = apply { this.userPausedDetails = userPausedDetails }
    }
}
