// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about an identity that performed an action on an affected resource by using temporary security credentials. The credentials were obtained using the GetFederationToken operation of the Security Token Service (STS) API.
 */
class FederatedUser private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Web Services access key ID that identifies the credentials.
     */
    val accessKeyId: String? = builder.accessKeyId
    /**
     * The unique identifier for the Amazon Web Services account that owns the entity that was used to get the credentials.
     */
    val accountId: String? = builder.accountId
    /**
     * The Amazon Resource Name (ARN) of the entity that was used to get the credentials.
     */
    val arn: String? = builder.arn
    /**
     * The unique identifier for the entity that was used to get the credentials.
     */
    val principalId: String? = builder.principalId
    /**
     * The details of the session that was created for the credentials, including the entity that issued the session.
     */
    val sessionContext: SessionContext? = builder.sessionContext

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): FederatedUser = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("FederatedUser(")
        append("accessKeyId=$accessKeyId,")
        append("accountId=$accountId,")
        append("arn=$arn,")
        append("principalId=$principalId,")
        append("sessionContext=$sessionContext)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessKeyId?.hashCode() ?: 0
        result = 31 * result + (accountId?.hashCode() ?: 0)
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (principalId?.hashCode() ?: 0)
        result = 31 * result + (sessionContext?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as FederatedUser

        if (accessKeyId != other.accessKeyId) return false
        if (accountId != other.accountId) return false
        if (arn != other.arn) return false
        if (principalId != other.principalId) return false
        if (sessionContext != other.sessionContext) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): FederatedUser = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): FederatedUser
        /**
         * The Amazon Web Services access key ID that identifies the credentials.
         */
        fun accessKeyId(accessKeyId: String): FluentBuilder
        /**
         * The unique identifier for the Amazon Web Services account that owns the entity that was used to get the credentials.
         */
        fun accountId(accountId: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the entity that was used to get the credentials.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The unique identifier for the entity that was used to get the credentials.
         */
        fun principalId(principalId: String): FluentBuilder
        /**
         * The details of the session that was created for the credentials, including the entity that issued the session.
         */
        fun sessionContext(sessionContext: SessionContext): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Web Services access key ID that identifies the credentials.
         */
        var accessKeyId: String?
        /**
         * The unique identifier for the Amazon Web Services account that owns the entity that was used to get the credentials.
         */
        var accountId: String?
        /**
         * The Amazon Resource Name (ARN) of the entity that was used to get the credentials.
         */
        var arn: String?
        /**
         * The unique identifier for the entity that was used to get the credentials.
         */
        var principalId: String?
        /**
         * The details of the session that was created for the credentials, including the entity that issued the session.
         */
        var sessionContext: SessionContext?

        fun build(): FederatedUser
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.SessionContext] inside the given [block]
         */
        fun sessionContext(block: SessionContext.DslBuilder.() -> kotlin.Unit) {
            this.sessionContext = SessionContext.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accessKeyId: String? = null
        override var accountId: String? = null
        override var arn: String? = null
        override var principalId: String? = null
        override var sessionContext: SessionContext? = null

        constructor(x: FederatedUser) : this() {
            this.accessKeyId = x.accessKeyId
            this.accountId = x.accountId
            this.arn = x.arn
            this.principalId = x.principalId
            this.sessionContext = x.sessionContext
        }

        override fun build(): FederatedUser = FederatedUser(this)
        override fun accessKeyId(accessKeyId: String): FluentBuilder = apply { this.accessKeyId = accessKeyId }
        override fun accountId(accountId: String): FluentBuilder = apply { this.accountId = accountId }
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun principalId(principalId: String): FluentBuilder = apply { this.principalId = principalId }
        override fun sessionContext(sessionContext: SessionContext): FluentBuilder = apply { this.sessionContext = sessionContext }
    }
}
