// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides the details of a finding.
 */
class Finding private constructor(builder: BuilderImpl) {
    /**
     * The unique identifier for the Amazon Web Services account that the finding applies to. This is typically the account that owns the affected resource.
     */
    val accountId: String? = builder.accountId
    /**
     * Specifies whether the finding is archived (suppressed).
     */
    val archived: Boolean? = builder.archived
    /**
     * The category of the finding. Possible values are: CLASSIFICATION, for a sensitive data finding; and, POLICY, for a policy finding.
     */
    val category: FindingCategory? = builder.category
    /**
     * The details of a sensitive data finding. This value is null for a policy finding.
     */
    val classificationDetails: ClassificationDetails? = builder.classificationDetails
    /**
     * The total number of occurrences of the finding. For sensitive data findings, this value is always 1. All sensitive data findings are considered new (unique) because they derive from individual classification jobs.
     */
    val count: Long? = builder.count
    /**
     * The date and time, in UTC and extended ISO 8601 format, when the finding was created.
     */
    val createdAt: Instant? = builder.createdAt
    /**
     * The description of the finding.
     */
    val description: String? = builder.description
    /**
     * The unique identifier for the finding. This is a random string that Amazon Macie generates and assigns to a finding when it creates the finding.
     */
    val id: String? = builder.id
    /**
     * The Amazon Web Services partition that Amazon Macie created the finding in.
     */
    val partition: String? = builder.partition
    /**
     * The details of a policy finding. This value is null for a sensitive data finding.
     */
    val policyDetails: PolicyDetails? = builder.policyDetails
    /**
     * The Amazon Web Services Region that Amazon Macie created the finding in.
     */
    val region: String? = builder.region
    /**
     * The resources that the finding applies to.
     */
    val resourcesAffected: ResourcesAffected? = builder.resourcesAffected
    /**
     * Specifies whether the finding is a sample finding. A sample finding is a finding that uses example data to demonstrate what a finding might contain.
     */
    val sample: Boolean? = builder.sample
    /**
     * The version of the schema that was used to define the data structures in the finding.
     */
    val schemaVersion: String? = builder.schemaVersion
    /**
     * The severity level and score for the finding.
     */
    val severity: Severity? = builder.severity
    /**
     * The brief description of the finding.
     */
    val title: String? = builder.title
    /**
     * The type of the finding.
     */
    val type: FindingType? = builder.type
    /**
     * The date and time, in UTC and extended ISO 8601 format, when the finding was last updated. For sensitive data findings, this value is the same as the value for the createdAt property. All sensitive data findings are considered new (unique) because they derive from individual classification jobs.
     */
    val updatedAt: Instant? = builder.updatedAt

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Finding = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Finding(")
        append("accountId=$accountId,")
        append("archived=$archived,")
        append("category=$category,")
        append("classificationDetails=$classificationDetails,")
        append("count=$count,")
        append("createdAt=$createdAt,")
        append("description=$description,")
        append("id=$id,")
        append("partition=$partition,")
        append("policyDetails=$policyDetails,")
        append("region=$region,")
        append("resourcesAffected=$resourcesAffected,")
        append("sample=$sample,")
        append("schemaVersion=$schemaVersion,")
        append("severity=$severity,")
        append("title=$title,")
        append("type=$type,")
        append("updatedAt=$updatedAt)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (archived?.hashCode() ?: 0)
        result = 31 * result + (category?.hashCode() ?: 0)
        result = 31 * result + (classificationDetails?.hashCode() ?: 0)
        result = 31 * result + (count?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (partition?.hashCode() ?: 0)
        result = 31 * result + (policyDetails?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (resourcesAffected?.hashCode() ?: 0)
        result = 31 * result + (sample?.hashCode() ?: 0)
        result = 31 * result + (schemaVersion?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Finding

        if (accountId != other.accountId) return false
        if (archived != other.archived) return false
        if (category != other.category) return false
        if (classificationDetails != other.classificationDetails) return false
        if (count != other.count) return false
        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (partition != other.partition) return false
        if (policyDetails != other.policyDetails) return false
        if (region != other.region) return false
        if (resourcesAffected != other.resourcesAffected) return false
        if (sample != other.sample) return false
        if (schemaVersion != other.schemaVersion) return false
        if (severity != other.severity) return false
        if (title != other.title) return false
        if (type != other.type) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Finding = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Finding
        /**
         * The unique identifier for the Amazon Web Services account that the finding applies to. This is typically the account that owns the affected resource.
         */
        fun accountId(accountId: String): FluentBuilder
        /**
         * Specifies whether the finding is archived (suppressed).
         */
        fun archived(archived: Boolean): FluentBuilder
        /**
         * The category of the finding. Possible values are: CLASSIFICATION, for a sensitive data finding; and, POLICY, for a policy finding.
         */
        fun category(category: FindingCategory): FluentBuilder
        /**
         * The details of a sensitive data finding. This value is null for a policy finding.
         */
        fun classificationDetails(classificationDetails: ClassificationDetails): FluentBuilder
        /**
         * The total number of occurrences of the finding. For sensitive data findings, this value is always 1. All sensitive data findings are considered new (unique) because they derive from individual classification jobs.
         */
        fun count(count: Long): FluentBuilder
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the finding was created.
         */
        fun createdAt(createdAt: Instant): FluentBuilder
        /**
         * The description of the finding.
         */
        fun description(description: String): FluentBuilder
        /**
         * The unique identifier for the finding. This is a random string that Amazon Macie generates and assigns to a finding when it creates the finding.
         */
        fun id(id: String): FluentBuilder
        /**
         * The Amazon Web Services partition that Amazon Macie created the finding in.
         */
        fun partition(partition: String): FluentBuilder
        /**
         * The details of a policy finding. This value is null for a sensitive data finding.
         */
        fun policyDetails(policyDetails: PolicyDetails): FluentBuilder
        /**
         * The Amazon Web Services Region that Amazon Macie created the finding in.
         */
        fun region(region: String): FluentBuilder
        /**
         * The resources that the finding applies to.
         */
        fun resourcesAffected(resourcesAffected: ResourcesAffected): FluentBuilder
        /**
         * Specifies whether the finding is a sample finding. A sample finding is a finding that uses example data to demonstrate what a finding might contain.
         */
        fun sample(sample: Boolean): FluentBuilder
        /**
         * The version of the schema that was used to define the data structures in the finding.
         */
        fun schemaVersion(schemaVersion: String): FluentBuilder
        /**
         * The severity level and score for the finding.
         */
        fun severity(severity: Severity): FluentBuilder
        /**
         * The brief description of the finding.
         */
        fun title(title: String): FluentBuilder
        /**
         * The type of the finding.
         */
        fun type(type: FindingType): FluentBuilder
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the finding was last updated. For sensitive data findings, this value is the same as the value for the createdAt property. All sensitive data findings are considered new (unique) because they derive from individual classification jobs.
         */
        fun updatedAt(updatedAt: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The unique identifier for the Amazon Web Services account that the finding applies to. This is typically the account that owns the affected resource.
         */
        var accountId: String?
        /**
         * Specifies whether the finding is archived (suppressed).
         */
        var archived: Boolean?
        /**
         * The category of the finding. Possible values are: CLASSIFICATION, for a sensitive data finding; and, POLICY, for a policy finding.
         */
        var category: FindingCategory?
        /**
         * The details of a sensitive data finding. This value is null for a policy finding.
         */
        var classificationDetails: ClassificationDetails?
        /**
         * The total number of occurrences of the finding. For sensitive data findings, this value is always 1. All sensitive data findings are considered new (unique) because they derive from individual classification jobs.
         */
        var count: Long?
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the finding was created.
         */
        var createdAt: Instant?
        /**
         * The description of the finding.
         */
        var description: String?
        /**
         * The unique identifier for the finding. This is a random string that Amazon Macie generates and assigns to a finding when it creates the finding.
         */
        var id: String?
        /**
         * The Amazon Web Services partition that Amazon Macie created the finding in.
         */
        var partition: String?
        /**
         * The details of a policy finding. This value is null for a sensitive data finding.
         */
        var policyDetails: PolicyDetails?
        /**
         * The Amazon Web Services Region that Amazon Macie created the finding in.
         */
        var region: String?
        /**
         * The resources that the finding applies to.
         */
        var resourcesAffected: ResourcesAffected?
        /**
         * Specifies whether the finding is a sample finding. A sample finding is a finding that uses example data to demonstrate what a finding might contain.
         */
        var sample: Boolean?
        /**
         * The version of the schema that was used to define the data structures in the finding.
         */
        var schemaVersion: String?
        /**
         * The severity level and score for the finding.
         */
        var severity: Severity?
        /**
         * The brief description of the finding.
         */
        var title: String?
        /**
         * The type of the finding.
         */
        var type: FindingType?
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the finding was last updated. For sensitive data findings, this value is the same as the value for the createdAt property. All sensitive data findings are considered new (unique) because they derive from individual classification jobs.
         */
        var updatedAt: Instant?

        fun build(): Finding
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.ClassificationDetails] inside the given [block]
         */
        fun classificationDetails(block: ClassificationDetails.DslBuilder.() -> kotlin.Unit) {
            this.classificationDetails = ClassificationDetails.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.PolicyDetails] inside the given [block]
         */
        fun policyDetails(block: PolicyDetails.DslBuilder.() -> kotlin.Unit) {
            this.policyDetails = PolicyDetails.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.ResourcesAffected] inside the given [block]
         */
        fun resourcesAffected(block: ResourcesAffected.DslBuilder.() -> kotlin.Unit) {
            this.resourcesAffected = ResourcesAffected.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.Severity] inside the given [block]
         */
        fun severity(block: Severity.DslBuilder.() -> kotlin.Unit) {
            this.severity = Severity.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accountId: String? = null
        override var archived: Boolean? = null
        override var category: FindingCategory? = null
        override var classificationDetails: ClassificationDetails? = null
        override var count: Long? = null
        override var createdAt: Instant? = null
        override var description: String? = null
        override var id: String? = null
        override var partition: String? = null
        override var policyDetails: PolicyDetails? = null
        override var region: String? = null
        override var resourcesAffected: ResourcesAffected? = null
        override var sample: Boolean? = null
        override var schemaVersion: String? = null
        override var severity: Severity? = null
        override var title: String? = null
        override var type: FindingType? = null
        override var updatedAt: Instant? = null

        constructor(x: Finding) : this() {
            this.accountId = x.accountId
            this.archived = x.archived
            this.category = x.category
            this.classificationDetails = x.classificationDetails
            this.count = x.count
            this.createdAt = x.createdAt
            this.description = x.description
            this.id = x.id
            this.partition = x.partition
            this.policyDetails = x.policyDetails
            this.region = x.region
            this.resourcesAffected = x.resourcesAffected
            this.sample = x.sample
            this.schemaVersion = x.schemaVersion
            this.severity = x.severity
            this.title = x.title
            this.type = x.type
            this.updatedAt = x.updatedAt
        }

        override fun build(): Finding = Finding(this)
        override fun accountId(accountId: String): FluentBuilder = apply { this.accountId = accountId }
        override fun archived(archived: Boolean): FluentBuilder = apply { this.archived = archived }
        override fun category(category: FindingCategory): FluentBuilder = apply { this.category = category }
        override fun classificationDetails(classificationDetails: ClassificationDetails): FluentBuilder = apply { this.classificationDetails = classificationDetails }
        override fun count(count: Long): FluentBuilder = apply { this.count = count }
        override fun createdAt(createdAt: Instant): FluentBuilder = apply { this.createdAt = createdAt }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun partition(partition: String): FluentBuilder = apply { this.partition = partition }
        override fun policyDetails(policyDetails: PolicyDetails): FluentBuilder = apply { this.policyDetails = policyDetails }
        override fun region(region: String): FluentBuilder = apply { this.region = region }
        override fun resourcesAffected(resourcesAffected: ResourcesAffected): FluentBuilder = apply { this.resourcesAffected = resourcesAffected }
        override fun sample(sample: Boolean): FluentBuilder = apply { this.sample = sample }
        override fun schemaVersion(schemaVersion: String): FluentBuilder = apply { this.schemaVersion = schemaVersion }
        override fun severity(severity: Severity): FluentBuilder = apply { this.severity = severity }
        override fun title(title: String): FluentBuilder = apply { this.title = title }
        override fun type(type: FindingType): FluentBuilder = apply { this.type = type }
        override fun updatedAt(updatedAt: Instant): FluentBuilder = apply { this.updatedAt = updatedAt }
    }
}
