// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about an action that occurred for a resource and produced a policy finding.
 */
class FindingAction private constructor(builder: BuilderImpl) {
    /**
     * The type of action that occurred for the affected resource. This value is typically AWS_API_CALL, which indicates that an entity invoked an API operation for the resource.
     */
    val actionType: FindingActionType? = builder.actionType
    /**
     * The invocation details of the API operation that an entity invoked for the affected resource, if the value for the actionType property is AWS_API_CALL.
     */
    val apiCallDetails: ApiCallDetails? = builder.apiCallDetails

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): FindingAction = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("FindingAction(")
        append("actionType=$actionType,")
        append("apiCallDetails=$apiCallDetails)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionType?.hashCode() ?: 0
        result = 31 * result + (apiCallDetails?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as FindingAction

        if (actionType != other.actionType) return false
        if (apiCallDetails != other.apiCallDetails) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): FindingAction = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): FindingAction
        /**
         * The type of action that occurred for the affected resource. This value is typically AWS_API_CALL, which indicates that an entity invoked an API operation for the resource.
         */
        fun actionType(actionType: FindingActionType): FluentBuilder
        /**
         * The invocation details of the API operation that an entity invoked for the affected resource, if the value for the actionType property is AWS_API_CALL.
         */
        fun apiCallDetails(apiCallDetails: ApiCallDetails): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The type of action that occurred for the affected resource. This value is typically AWS_API_CALL, which indicates that an entity invoked an API operation for the resource.
         */
        var actionType: FindingActionType?
        /**
         * The invocation details of the API operation that an entity invoked for the affected resource, if the value for the actionType property is AWS_API_CALL.
         */
        var apiCallDetails: ApiCallDetails?

        fun build(): FindingAction
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.ApiCallDetails] inside the given [block]
         */
        fun apiCallDetails(block: ApiCallDetails.DslBuilder.() -> kotlin.Unit) {
            this.apiCallDetails = ApiCallDetails.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var actionType: FindingActionType? = null
        override var apiCallDetails: ApiCallDetails? = null

        constructor(x: FindingAction) : this() {
            this.actionType = x.actionType
            this.apiCallDetails = x.apiCallDetails
        }

        override fun build(): FindingAction = FindingAction(this)
        override fun actionType(actionType: FindingActionType): FluentBuilder = apply { this.actionType = actionType }
        override fun apiCallDetails(apiCallDetails: ApiCallDetails): FluentBuilder = apply { this.apiCallDetails = apiCallDetails }
    }
}
