// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about an entity that performed an action that produced a policy finding for a resource.
 */
class FindingActor private constructor(builder: BuilderImpl) {
    /**
     * The domain name of the device that the entity used to perform the action on the affected resource.
     */
    val domainDetails: DomainDetails? = builder.domainDetails
    /**
     * The IP address of the device that the entity used to perform the action on the affected resource. This object also provides information such as the owner and geographic location for the IP address.
     */
    val ipAddressDetails: IpAddressDetails? = builder.ipAddressDetails
    /**
     * The type and other characteristics of the entity that performed the action on the affected resource.
     */
    val userIdentity: UserIdentity? = builder.userIdentity

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): FindingActor = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("FindingActor(")
        append("domainDetails=$domainDetails,")
        append("ipAddressDetails=$ipAddressDetails,")
        append("userIdentity=$userIdentity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainDetails?.hashCode() ?: 0
        result = 31 * result + (ipAddressDetails?.hashCode() ?: 0)
        result = 31 * result + (userIdentity?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as FindingActor

        if (domainDetails != other.domainDetails) return false
        if (ipAddressDetails != other.ipAddressDetails) return false
        if (userIdentity != other.userIdentity) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): FindingActor = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): FindingActor
        /**
         * The domain name of the device that the entity used to perform the action on the affected resource.
         */
        fun domainDetails(domainDetails: DomainDetails): FluentBuilder
        /**
         * The IP address of the device that the entity used to perform the action on the affected resource. This object also provides information such as the owner and geographic location for the IP address.
         */
        fun ipAddressDetails(ipAddressDetails: IpAddressDetails): FluentBuilder
        /**
         * The type and other characteristics of the entity that performed the action on the affected resource.
         */
        fun userIdentity(userIdentity: UserIdentity): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The domain name of the device that the entity used to perform the action on the affected resource.
         */
        var domainDetails: DomainDetails?
        /**
         * The IP address of the device that the entity used to perform the action on the affected resource. This object also provides information such as the owner and geographic location for the IP address.
         */
        var ipAddressDetails: IpAddressDetails?
        /**
         * The type and other characteristics of the entity that performed the action on the affected resource.
         */
        var userIdentity: UserIdentity?

        fun build(): FindingActor
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.DomainDetails] inside the given [block]
         */
        fun domainDetails(block: DomainDetails.DslBuilder.() -> kotlin.Unit) {
            this.domainDetails = DomainDetails.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.IpAddressDetails] inside the given [block]
         */
        fun ipAddressDetails(block: IpAddressDetails.DslBuilder.() -> kotlin.Unit) {
            this.ipAddressDetails = IpAddressDetails.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.UserIdentity] inside the given [block]
         */
        fun userIdentity(block: UserIdentity.DslBuilder.() -> kotlin.Unit) {
            this.userIdentity = UserIdentity.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var domainDetails: DomainDetails? = null
        override var ipAddressDetails: IpAddressDetails? = null
        override var userIdentity: UserIdentity? = null

        constructor(x: FindingActor) : this() {
            this.domainDetails = x.domainDetails
            this.ipAddressDetails = x.ipAddressDetails
            this.userIdentity = x.userIdentity
        }

        override fun build(): FindingActor = FindingActor(this)
        override fun domainDetails(domainDetails: DomainDetails): FluentBuilder = apply { this.domainDetails = domainDetails }
        override fun ipAddressDetails(ipAddressDetails: IpAddressDetails): FluentBuilder = apply { this.ipAddressDetails = ipAddressDetails }
        override fun userIdentity(userIdentity: UserIdentity): FluentBuilder = apply { this.userIdentity = userIdentity }
    }
}
