// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about a findings filter.
 */
class FindingsFilterListItem private constructor(builder: BuilderImpl) {
    /**
     * The action that's performed on findings that meet the filter criteria. Possible values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.
     */
    val action: FindingsFilterAction? = builder.action
    /**
     * The Amazon Resource Name (ARN) of the filter.
     */
    val arn: String? = builder.arn
    /**
     * The unique identifier for the filter.
     */
    val id: String? = builder.id
    /**
     * The custom name of the filter.
     */
    val name: String? = builder.name
    /**
     * A map of key-value pairs that identifies the tags (keys and values) that are associated with the filter.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): FindingsFilterListItem = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("FindingsFilterListItem(")
        append("action=$action,")
        append("arn=$arn,")
        append("id=$id,")
        append("name=$name,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as FindingsFilterListItem

        if (action != other.action) return false
        if (arn != other.arn) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): FindingsFilterListItem = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): FindingsFilterListItem
        /**
         * The action that's performed on findings that meet the filter criteria. Possible values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.
         */
        fun action(action: FindingsFilterAction): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the filter.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The unique identifier for the filter.
         */
        fun id(id: String): FluentBuilder
        /**
         * The custom name of the filter.
         */
        fun name(name: String): FluentBuilder
        /**
         * A map of key-value pairs that identifies the tags (keys and values) that are associated with the filter.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The action that's performed on findings that meet the filter criteria. Possible values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.
         */
        var action: FindingsFilterAction?
        /**
         * The Amazon Resource Name (ARN) of the filter.
         */
        var arn: String?
        /**
         * The unique identifier for the filter.
         */
        var id: String?
        /**
         * The custom name of the filter.
         */
        var name: String?
        /**
         * A map of key-value pairs that identifies the tags (keys and values) that are associated with the filter.
         */
        var tags: Map<String, String>?

        fun build(): FindingsFilterListItem
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var action: FindingsFilterAction? = null
        override var arn: String? = null
        override var id: String? = null
        override var name: String? = null
        override var tags: Map<String, String>? = null

        constructor(x: FindingsFilterListItem) : this() {
            this.action = x.action
            this.arn = x.arn
            this.id = x.id
            this.name = x.name
            this.tags = x.tags
        }

        override fun build(): FindingsFilterListItem = FindingsFilterListItem(this)
        override fun action(action: FindingsFilterAction): FluentBuilder = apply { this.action = action }
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
