// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model

import aws.smithy.kotlin.runtime.time.Instant

class GetBucketStatisticsResponse private constructor(builder: BuilderImpl) {
    /**
     * The total number of buckets.
     */
    val bucketCount: Long? = builder.bucketCount
    /**
     * The total number of buckets that are publicly accessible based on a combination of permissions settings for each bucket.
     */
    val bucketCountByEffectivePermission: BucketCountByEffectivePermission? = builder.bucketCountByEffectivePermission
    /**
     * The total number of buckets that use certain types of server-side encryption to encrypt new objects by default. This object also reports the total number of buckets that don't encrypt new objects by default.
     */
    val bucketCountByEncryptionType: BucketCountByEncryptionType? = builder.bucketCountByEncryptionType
    /**
     * The total number of buckets whose bucket policies do or don't require server-side encryption of objects when objects are uploaded to the buckets.
     */
    val bucketCountByObjectEncryptionRequirement: BucketCountPolicyAllowsUnencryptedObjectUploads? = builder.bucketCountByObjectEncryptionRequirement
    /**
     * The total number of buckets that are or aren't shared with another Amazon Web Services account.
     */
    val bucketCountBySharedAccessType: BucketCountBySharedAccessType? = builder.bucketCountBySharedAccessType
    /**
     * The total number of objects that Amazon Macie can analyze in the buckets. These objects use a supported storage class and have a file name extension for a supported file or storage format.
     */
    val classifiableObjectCount: Long? = builder.classifiableObjectCount
    /**
     * The total storage size, in bytes, of all the objects that Amazon Macie can analyze in the buckets. These objects use a supported storage class and have a file name extension for a supported file or storage format. If versioning is enabled for any of the buckets, Macie calculates this value based on the size of the latest version of each applicable object in those buckets. This value doesn't reflect the storage size of all versions of all applicable objects in the buckets.
     */
    val classifiableSizeInBytes: Long? = builder.classifiableSizeInBytes
    /**
     * The date and time, in UTC and extended ISO 8601 format, when Amazon Macie most recently retrieved both bucket and object metadata from Amazon S3 for the buckets.
     */
    val lastUpdated: Instant? = builder.lastUpdated
    /**
     * The total number of objects in the buckets.
     */
    val objectCount: Long? = builder.objectCount
    /**
     * The total storage size, in bytes, of the buckets. If versioning is enabled for any of the buckets, Macie calculates this value based on the size of the latest version of each object in those buckets. This value doesn't reflect the storage size of all versions of the objects in the buckets.
     */
    val sizeInBytes: Long? = builder.sizeInBytes
    /**
     * The total storage size, in bytes, of the objects that are compressed (.gz, .gzip, .zip) files in the buckets. If versioning is enabled for any of the buckets, Macie calculates this value based on the size of the latest version of each applicable object in those buckets. This value doesn't reflect the storage size of all versions of the applicable objects in the buckets.
     */
    val sizeInBytesCompressed: Long? = builder.sizeInBytesCompressed
    /**
     * The total number of objects that Amazon Macie can't analyze in the buckets. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.
     */
    val unclassifiableObjectCount: ObjectLevelStatistics? = builder.unclassifiableObjectCount
    /**
     * The total storage size, in bytes, of the objects that Amazon Macie can't analyze in the buckets. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.
     */
    val unclassifiableObjectSizeInBytes: ObjectLevelStatistics? = builder.unclassifiableObjectSizeInBytes

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GetBucketStatisticsResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GetBucketStatisticsResponse(")
        append("bucketCount=$bucketCount,")
        append("bucketCountByEffectivePermission=$bucketCountByEffectivePermission,")
        append("bucketCountByEncryptionType=$bucketCountByEncryptionType,")
        append("bucketCountByObjectEncryptionRequirement=$bucketCountByObjectEncryptionRequirement,")
        append("bucketCountBySharedAccessType=$bucketCountBySharedAccessType,")
        append("classifiableObjectCount=$classifiableObjectCount,")
        append("classifiableSizeInBytes=$classifiableSizeInBytes,")
        append("lastUpdated=$lastUpdated,")
        append("objectCount=$objectCount,")
        append("sizeInBytes=$sizeInBytes,")
        append("sizeInBytesCompressed=$sizeInBytesCompressed,")
        append("unclassifiableObjectCount=$unclassifiableObjectCount,")
        append("unclassifiableObjectSizeInBytes=$unclassifiableObjectSizeInBytes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketCount?.hashCode() ?: 0
        result = 31 * result + (bucketCountByEffectivePermission?.hashCode() ?: 0)
        result = 31 * result + (bucketCountByEncryptionType?.hashCode() ?: 0)
        result = 31 * result + (bucketCountByObjectEncryptionRequirement?.hashCode() ?: 0)
        result = 31 * result + (bucketCountBySharedAccessType?.hashCode() ?: 0)
        result = 31 * result + (classifiableObjectCount?.hashCode() ?: 0)
        result = 31 * result + (classifiableSizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (lastUpdated?.hashCode() ?: 0)
        result = 31 * result + (objectCount?.hashCode() ?: 0)
        result = 31 * result + (sizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (sizeInBytesCompressed?.hashCode() ?: 0)
        result = 31 * result + (unclassifiableObjectCount?.hashCode() ?: 0)
        result = 31 * result + (unclassifiableObjectSizeInBytes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetBucketStatisticsResponse

        if (bucketCount != other.bucketCount) return false
        if (bucketCountByEffectivePermission != other.bucketCountByEffectivePermission) return false
        if (bucketCountByEncryptionType != other.bucketCountByEncryptionType) return false
        if (bucketCountByObjectEncryptionRequirement != other.bucketCountByObjectEncryptionRequirement) return false
        if (bucketCountBySharedAccessType != other.bucketCountBySharedAccessType) return false
        if (classifiableObjectCount != other.classifiableObjectCount) return false
        if (classifiableSizeInBytes != other.classifiableSizeInBytes) return false
        if (lastUpdated != other.lastUpdated) return false
        if (objectCount != other.objectCount) return false
        if (sizeInBytes != other.sizeInBytes) return false
        if (sizeInBytesCompressed != other.sizeInBytesCompressed) return false
        if (unclassifiableObjectCount != other.unclassifiableObjectCount) return false
        if (unclassifiableObjectSizeInBytes != other.unclassifiableObjectSizeInBytes) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GetBucketStatisticsResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GetBucketStatisticsResponse
        /**
         * The total number of buckets.
         */
        fun bucketCount(bucketCount: Long): FluentBuilder
        /**
         * The total number of buckets that are publicly accessible based on a combination of permissions settings for each bucket.
         */
        fun bucketCountByEffectivePermission(bucketCountByEffectivePermission: BucketCountByEffectivePermission): FluentBuilder
        /**
         * The total number of buckets that use certain types of server-side encryption to encrypt new objects by default. This object also reports the total number of buckets that don't encrypt new objects by default.
         */
        fun bucketCountByEncryptionType(bucketCountByEncryptionType: BucketCountByEncryptionType): FluentBuilder
        /**
         * The total number of buckets whose bucket policies do or don't require server-side encryption of objects when objects are uploaded to the buckets.
         */
        fun bucketCountByObjectEncryptionRequirement(bucketCountByObjectEncryptionRequirement: BucketCountPolicyAllowsUnencryptedObjectUploads): FluentBuilder
        /**
         * The total number of buckets that are or aren't shared with another Amazon Web Services account.
         */
        fun bucketCountBySharedAccessType(bucketCountBySharedAccessType: BucketCountBySharedAccessType): FluentBuilder
        /**
         * The total number of objects that Amazon Macie can analyze in the buckets. These objects use a supported storage class and have a file name extension for a supported file or storage format.
         */
        fun classifiableObjectCount(classifiableObjectCount: Long): FluentBuilder
        /**
         * The total storage size, in bytes, of all the objects that Amazon Macie can analyze in the buckets. These objects use a supported storage class and have a file name extension for a supported file or storage format. If versioning is enabled for any of the buckets, Macie calculates this value based on the size of the latest version of each applicable object in those buckets. This value doesn't reflect the storage size of all versions of all applicable objects in the buckets.
         */
        fun classifiableSizeInBytes(classifiableSizeInBytes: Long): FluentBuilder
        /**
         * The date and time, in UTC and extended ISO 8601 format, when Amazon Macie most recently retrieved both bucket and object metadata from Amazon S3 for the buckets.
         */
        fun lastUpdated(lastUpdated: Instant): FluentBuilder
        /**
         * The total number of objects in the buckets.
         */
        fun objectCount(objectCount: Long): FluentBuilder
        /**
         * The total storage size, in bytes, of the buckets. If versioning is enabled for any of the buckets, Macie calculates this value based on the size of the latest version of each object in those buckets. This value doesn't reflect the storage size of all versions of the objects in the buckets.
         */
        fun sizeInBytes(sizeInBytes: Long): FluentBuilder
        /**
         * The total storage size, in bytes, of the objects that are compressed (.gz, .gzip, .zip) files in the buckets. If versioning is enabled for any of the buckets, Macie calculates this value based on the size of the latest version of each applicable object in those buckets. This value doesn't reflect the storage size of all versions of the applicable objects in the buckets.
         */
        fun sizeInBytesCompressed(sizeInBytesCompressed: Long): FluentBuilder
        /**
         * The total number of objects that Amazon Macie can't analyze in the buckets. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.
         */
        fun unclassifiableObjectCount(unclassifiableObjectCount: ObjectLevelStatistics): FluentBuilder
        /**
         * The total storage size, in bytes, of the objects that Amazon Macie can't analyze in the buckets. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.
         */
        fun unclassifiableObjectSizeInBytes(unclassifiableObjectSizeInBytes: ObjectLevelStatistics): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The total number of buckets.
         */
        var bucketCount: Long?
        /**
         * The total number of buckets that are publicly accessible based on a combination of permissions settings for each bucket.
         */
        var bucketCountByEffectivePermission: BucketCountByEffectivePermission?
        /**
         * The total number of buckets that use certain types of server-side encryption to encrypt new objects by default. This object also reports the total number of buckets that don't encrypt new objects by default.
         */
        var bucketCountByEncryptionType: BucketCountByEncryptionType?
        /**
         * The total number of buckets whose bucket policies do or don't require server-side encryption of objects when objects are uploaded to the buckets.
         */
        var bucketCountByObjectEncryptionRequirement: BucketCountPolicyAllowsUnencryptedObjectUploads?
        /**
         * The total number of buckets that are or aren't shared with another Amazon Web Services account.
         */
        var bucketCountBySharedAccessType: BucketCountBySharedAccessType?
        /**
         * The total number of objects that Amazon Macie can analyze in the buckets. These objects use a supported storage class and have a file name extension for a supported file or storage format.
         */
        var classifiableObjectCount: Long?
        /**
         * The total storage size, in bytes, of all the objects that Amazon Macie can analyze in the buckets. These objects use a supported storage class and have a file name extension for a supported file or storage format. If versioning is enabled for any of the buckets, Macie calculates this value based on the size of the latest version of each applicable object in those buckets. This value doesn't reflect the storage size of all versions of all applicable objects in the buckets.
         */
        var classifiableSizeInBytes: Long?
        /**
         * The date and time, in UTC and extended ISO 8601 format, when Amazon Macie most recently retrieved both bucket and object metadata from Amazon S3 for the buckets.
         */
        var lastUpdated: Instant?
        /**
         * The total number of objects in the buckets.
         */
        var objectCount: Long?
        /**
         * The total storage size, in bytes, of the buckets. If versioning is enabled for any of the buckets, Macie calculates this value based on the size of the latest version of each object in those buckets. This value doesn't reflect the storage size of all versions of the objects in the buckets.
         */
        var sizeInBytes: Long?
        /**
         * The total storage size, in bytes, of the objects that are compressed (.gz, .gzip, .zip) files in the buckets. If versioning is enabled for any of the buckets, Macie calculates this value based on the size of the latest version of each applicable object in those buckets. This value doesn't reflect the storage size of all versions of the applicable objects in the buckets.
         */
        var sizeInBytesCompressed: Long?
        /**
         * The total number of objects that Amazon Macie can't analyze in the buckets. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.
         */
        var unclassifiableObjectCount: ObjectLevelStatistics?
        /**
         * The total storage size, in bytes, of the objects that Amazon Macie can't analyze in the buckets. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.
         */
        var unclassifiableObjectSizeInBytes: ObjectLevelStatistics?

        fun build(): GetBucketStatisticsResponse
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.BucketCountByEffectivePermission] inside the given [block]
         */
        fun bucketCountByEffectivePermission(block: BucketCountByEffectivePermission.DslBuilder.() -> kotlin.Unit) {
            this.bucketCountByEffectivePermission = BucketCountByEffectivePermission.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.BucketCountByEncryptionType] inside the given [block]
         */
        fun bucketCountByEncryptionType(block: BucketCountByEncryptionType.DslBuilder.() -> kotlin.Unit) {
            this.bucketCountByEncryptionType = BucketCountByEncryptionType.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.BucketCountPolicyAllowsUnencryptedObjectUploads] inside the given [block]
         */
        fun bucketCountByObjectEncryptionRequirement(block: BucketCountPolicyAllowsUnencryptedObjectUploads.DslBuilder.() -> kotlin.Unit) {
            this.bucketCountByObjectEncryptionRequirement = BucketCountPolicyAllowsUnencryptedObjectUploads.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.BucketCountBySharedAccessType] inside the given [block]
         */
        fun bucketCountBySharedAccessType(block: BucketCountBySharedAccessType.DslBuilder.() -> kotlin.Unit) {
            this.bucketCountBySharedAccessType = BucketCountBySharedAccessType.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics] inside the given [block]
         */
        fun unclassifiableObjectCount(block: ObjectLevelStatistics.DslBuilder.() -> kotlin.Unit) {
            this.unclassifiableObjectCount = ObjectLevelStatistics.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics] inside the given [block]
         */
        fun unclassifiableObjectSizeInBytes(block: ObjectLevelStatistics.DslBuilder.() -> kotlin.Unit) {
            this.unclassifiableObjectSizeInBytes = ObjectLevelStatistics.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var bucketCount: Long? = null
        override var bucketCountByEffectivePermission: BucketCountByEffectivePermission? = null
        override var bucketCountByEncryptionType: BucketCountByEncryptionType? = null
        override var bucketCountByObjectEncryptionRequirement: BucketCountPolicyAllowsUnencryptedObjectUploads? = null
        override var bucketCountBySharedAccessType: BucketCountBySharedAccessType? = null
        override var classifiableObjectCount: Long? = null
        override var classifiableSizeInBytes: Long? = null
        override var lastUpdated: Instant? = null
        override var objectCount: Long? = null
        override var sizeInBytes: Long? = null
        override var sizeInBytesCompressed: Long? = null
        override var unclassifiableObjectCount: ObjectLevelStatistics? = null
        override var unclassifiableObjectSizeInBytes: ObjectLevelStatistics? = null

        constructor(x: GetBucketStatisticsResponse) : this() {
            this.bucketCount = x.bucketCount
            this.bucketCountByEffectivePermission = x.bucketCountByEffectivePermission
            this.bucketCountByEncryptionType = x.bucketCountByEncryptionType
            this.bucketCountByObjectEncryptionRequirement = x.bucketCountByObjectEncryptionRequirement
            this.bucketCountBySharedAccessType = x.bucketCountBySharedAccessType
            this.classifiableObjectCount = x.classifiableObjectCount
            this.classifiableSizeInBytes = x.classifiableSizeInBytes
            this.lastUpdated = x.lastUpdated
            this.objectCount = x.objectCount
            this.sizeInBytes = x.sizeInBytes
            this.sizeInBytesCompressed = x.sizeInBytesCompressed
            this.unclassifiableObjectCount = x.unclassifiableObjectCount
            this.unclassifiableObjectSizeInBytes = x.unclassifiableObjectSizeInBytes
        }

        override fun build(): GetBucketStatisticsResponse = GetBucketStatisticsResponse(this)
        override fun bucketCount(bucketCount: Long): FluentBuilder = apply { this.bucketCount = bucketCount }
        override fun bucketCountByEffectivePermission(bucketCountByEffectivePermission: BucketCountByEffectivePermission): FluentBuilder = apply { this.bucketCountByEffectivePermission = bucketCountByEffectivePermission }
        override fun bucketCountByEncryptionType(bucketCountByEncryptionType: BucketCountByEncryptionType): FluentBuilder = apply { this.bucketCountByEncryptionType = bucketCountByEncryptionType }
        override fun bucketCountByObjectEncryptionRequirement(bucketCountByObjectEncryptionRequirement: BucketCountPolicyAllowsUnencryptedObjectUploads): FluentBuilder = apply { this.bucketCountByObjectEncryptionRequirement = bucketCountByObjectEncryptionRequirement }
        override fun bucketCountBySharedAccessType(bucketCountBySharedAccessType: BucketCountBySharedAccessType): FluentBuilder = apply { this.bucketCountBySharedAccessType = bucketCountBySharedAccessType }
        override fun classifiableObjectCount(classifiableObjectCount: Long): FluentBuilder = apply { this.classifiableObjectCount = classifiableObjectCount }
        override fun classifiableSizeInBytes(classifiableSizeInBytes: Long): FluentBuilder = apply { this.classifiableSizeInBytes = classifiableSizeInBytes }
        override fun lastUpdated(lastUpdated: Instant): FluentBuilder = apply { this.lastUpdated = lastUpdated }
        override fun objectCount(objectCount: Long): FluentBuilder = apply { this.objectCount = objectCount }
        override fun sizeInBytes(sizeInBytes: Long): FluentBuilder = apply { this.sizeInBytes = sizeInBytes }
        override fun sizeInBytesCompressed(sizeInBytesCompressed: Long): FluentBuilder = apply { this.sizeInBytesCompressed = sizeInBytesCompressed }
        override fun unclassifiableObjectCount(unclassifiableObjectCount: ObjectLevelStatistics): FluentBuilder = apply { this.unclassifiableObjectCount = unclassifiableObjectCount }
        override fun unclassifiableObjectSizeInBytes(unclassifiableObjectSizeInBytes: ObjectLevelStatistics): FluentBuilder = apply { this.unclassifiableObjectSizeInBytes = unclassifiableObjectSizeInBytes }
    }
}
