// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model

import aws.smithy.kotlin.runtime.time.Instant

class GetCustomDataIdentifierResponse private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the custom data identifier.
     */
    val arn: String? = builder.arn
    /**
     * The date and time, in UTC and extended ISO 8601 format, when the custom data identifier was created.
     */
    val createdAt: Instant? = builder.createdAt
    /**
     * Specifies whether the custom data identifier was deleted. If you delete a custom data identifier, Amazon Macie doesn't delete it permanently. Instead, it soft deletes the identifier.
     */
    val deleted: Boolean? = builder.deleted
    /**
     * The custom description of the custom data identifier.
     */
    val description: String? = builder.description
    /**
     * The unique identifier for the custom data identifier.
     */
    val id: String? = builder.id
    /**
     * An array that lists specific character sequences (ignore words) to exclude from the results. If the text matched by the regular expression is the same as any string in this array, Amazon Macie ignores it. Ignore words are case sensitive.
     */
    val ignoreWords: List<String>? = builder.ignoreWords
    /**
     * An array that lists specific character sequences (keywords), one of which must be within proximity (maximumMatchDistance) of the regular expression to match. Keywords aren't case sensitive.
     */
    val keywords: List<String>? = builder.keywords
    /**
     * The maximum number of characters that can exist between text that matches the regex pattern and the character sequences specified by the keywords array. Macie includes or excludes a result based on the proximity of a keyword to text that matches the regex pattern.
     */
    val maximumMatchDistance: Int? = builder.maximumMatchDistance
    /**
     * The custom name of the custom data identifier.
     */
    val name: String? = builder.name
    /**
     * The regular expression (regex) that defines the pattern to match.
     */
    val regex: String? = builder.regex
    /**
     * A map of key-value pairs that identifies the tags (keys and values) that are associated with the custom data identifier.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GetCustomDataIdentifierResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GetCustomDataIdentifierResponse(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("deleted=$deleted,")
        append("description=$description,")
        append("id=$id,")
        append("ignoreWords=$ignoreWords,")
        append("keywords=$keywords,")
        append("maximumMatchDistance=$maximumMatchDistance,")
        append("name=$name,")
        append("regex=$regex,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (deleted?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (ignoreWords?.hashCode() ?: 0)
        result = 31 * result + (keywords?.hashCode() ?: 0)
        result = 31 * result + (maximumMatchDistance ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (regex?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetCustomDataIdentifierResponse

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (deleted != other.deleted) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (ignoreWords != other.ignoreWords) return false
        if (keywords != other.keywords) return false
        if (maximumMatchDistance != other.maximumMatchDistance) return false
        if (name != other.name) return false
        if (regex != other.regex) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GetCustomDataIdentifierResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GetCustomDataIdentifierResponse
        /**
         * The Amazon Resource Name (ARN) of the custom data identifier.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the custom data identifier was created.
         */
        fun createdAt(createdAt: Instant): FluentBuilder
        /**
         * Specifies whether the custom data identifier was deleted. If you delete a custom data identifier, Amazon Macie doesn't delete it permanently. Instead, it soft deletes the identifier.
         */
        fun deleted(deleted: Boolean): FluentBuilder
        /**
         * The custom description of the custom data identifier.
         */
        fun description(description: String): FluentBuilder
        /**
         * The unique identifier for the custom data identifier.
         */
        fun id(id: String): FluentBuilder
        /**
         * An array that lists specific character sequences (ignore words) to exclude from the results. If the text matched by the regular expression is the same as any string in this array, Amazon Macie ignores it. Ignore words are case sensitive.
         */
        fun ignoreWords(ignoreWords: List<String>): FluentBuilder
        /**
         * An array that lists specific character sequences (keywords), one of which must be within proximity (maximumMatchDistance) of the regular expression to match. Keywords aren't case sensitive.
         */
        fun keywords(keywords: List<String>): FluentBuilder
        /**
         * The maximum number of characters that can exist between text that matches the regex pattern and the character sequences specified by the keywords array. Macie includes or excludes a result based on the proximity of a keyword to text that matches the regex pattern.
         */
        fun maximumMatchDistance(maximumMatchDistance: Int): FluentBuilder
        /**
         * The custom name of the custom data identifier.
         */
        fun name(name: String): FluentBuilder
        /**
         * The regular expression (regex) that defines the pattern to match.
         */
        fun regex(regex: String): FluentBuilder
        /**
         * A map of key-value pairs that identifies the tags (keys and values) that are associated with the custom data identifier.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the custom data identifier.
         */
        var arn: String?
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the custom data identifier was created.
         */
        var createdAt: Instant?
        /**
         * Specifies whether the custom data identifier was deleted. If you delete a custom data identifier, Amazon Macie doesn't delete it permanently. Instead, it soft deletes the identifier.
         */
        var deleted: Boolean?
        /**
         * The custom description of the custom data identifier.
         */
        var description: String?
        /**
         * The unique identifier for the custom data identifier.
         */
        var id: String?
        /**
         * An array that lists specific character sequences (ignore words) to exclude from the results. If the text matched by the regular expression is the same as any string in this array, Amazon Macie ignores it. Ignore words are case sensitive.
         */
        var ignoreWords: List<String>?
        /**
         * An array that lists specific character sequences (keywords), one of which must be within proximity (maximumMatchDistance) of the regular expression to match. Keywords aren't case sensitive.
         */
        var keywords: List<String>?
        /**
         * The maximum number of characters that can exist between text that matches the regex pattern and the character sequences specified by the keywords array. Macie includes or excludes a result based on the proximity of a keyword to text that matches the regex pattern.
         */
        var maximumMatchDistance: Int?
        /**
         * The custom name of the custom data identifier.
         */
        var name: String?
        /**
         * The regular expression (regex) that defines the pattern to match.
         */
        var regex: String?
        /**
         * A map of key-value pairs that identifies the tags (keys and values) that are associated with the custom data identifier.
         */
        var tags: Map<String, String>?

        fun build(): GetCustomDataIdentifierResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var createdAt: Instant? = null
        override var deleted: Boolean? = null
        override var description: String? = null
        override var id: String? = null
        override var ignoreWords: List<String>? = null
        override var keywords: List<String>? = null
        override var maximumMatchDistance: Int? = null
        override var name: String? = null
        override var regex: String? = null
        override var tags: Map<String, String>? = null

        constructor(x: GetCustomDataIdentifierResponse) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.deleted = x.deleted
            this.description = x.description
            this.id = x.id
            this.ignoreWords = x.ignoreWords
            this.keywords = x.keywords
            this.maximumMatchDistance = x.maximumMatchDistance
            this.name = x.name
            this.regex = x.regex
            this.tags = x.tags
        }

        override fun build(): GetCustomDataIdentifierResponse = GetCustomDataIdentifierResponse(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun createdAt(createdAt: Instant): FluentBuilder = apply { this.createdAt = createdAt }
        override fun deleted(deleted: Boolean): FluentBuilder = apply { this.deleted = deleted }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun ignoreWords(ignoreWords: List<String>): FluentBuilder = apply { this.ignoreWords = ignoreWords }
        override fun keywords(keywords: List<String>): FluentBuilder = apply { this.keywords = keywords }
        override fun maximumMatchDistance(maximumMatchDistance: Int): FluentBuilder = apply { this.maximumMatchDistance = maximumMatchDistance }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun regex(regex: String): FluentBuilder = apply { this.regex = regex }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
