// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



class GetFindingsFilterResponse private constructor(builder: BuilderImpl) {
    /**
     * The action that's performed on findings that meet the filter criteria (findingCriteria). Possible values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.
     */
    val action: FindingsFilterAction? = builder.action
    /**
     * The Amazon Resource Name (ARN) of the filter.
     */
    val arn: String? = builder.arn
    /**
     * The custom description of the filter.
     */
    val description: String? = builder.description
    /**
     * The criteria that's used to filter findings.
     */
    val findingCriteria: FindingCriteria? = builder.findingCriteria
    /**
     * The unique identifier for the filter.
     */
    val id: String? = builder.id
    /**
     * The custom name of the filter.
     */
    val name: String? = builder.name
    /**
     * The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.
     */
    val position: Int? = builder.position
    /**
     * A map of key-value pairs that identifies the tags (keys and values) that are associated with the filter.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GetFindingsFilterResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GetFindingsFilterResponse(")
        append("action=$action,")
        append("arn=$arn,")
        append("description=$description,")
        append("findingCriteria=$findingCriteria,")
        append("id=$id,")
        append("name=$name,")
        append("position=$position,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (findingCriteria?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (position ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetFindingsFilterResponse

        if (action != other.action) return false
        if (arn != other.arn) return false
        if (description != other.description) return false
        if (findingCriteria != other.findingCriteria) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (position != other.position) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GetFindingsFilterResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GetFindingsFilterResponse
        /**
         * The action that's performed on findings that meet the filter criteria (findingCriteria). Possible values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.
         */
        fun action(action: FindingsFilterAction): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the filter.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The custom description of the filter.
         */
        fun description(description: String): FluentBuilder
        /**
         * The criteria that's used to filter findings.
         */
        fun findingCriteria(findingCriteria: FindingCriteria): FluentBuilder
        /**
         * The unique identifier for the filter.
         */
        fun id(id: String): FluentBuilder
        /**
         * The custom name of the filter.
         */
        fun name(name: String): FluentBuilder
        /**
         * The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.
         */
        fun position(position: Int): FluentBuilder
        /**
         * A map of key-value pairs that identifies the tags (keys and values) that are associated with the filter.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The action that's performed on findings that meet the filter criteria (findingCriteria). Possible values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.
         */
        var action: FindingsFilterAction?
        /**
         * The Amazon Resource Name (ARN) of the filter.
         */
        var arn: String?
        /**
         * The custom description of the filter.
         */
        var description: String?
        /**
         * The criteria that's used to filter findings.
         */
        var findingCriteria: FindingCriteria?
        /**
         * The unique identifier for the filter.
         */
        var id: String?
        /**
         * The custom name of the filter.
         */
        var name: String?
        /**
         * The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.
         */
        var position: Int?
        /**
         * A map of key-value pairs that identifies the tags (keys and values) that are associated with the filter.
         */
        var tags: Map<String, String>?

        fun build(): GetFindingsFilterResponse
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.FindingCriteria] inside the given [block]
         */
        fun findingCriteria(block: FindingCriteria.DslBuilder.() -> kotlin.Unit) {
            this.findingCriteria = FindingCriteria.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var action: FindingsFilterAction? = null
        override var arn: String? = null
        override var description: String? = null
        override var findingCriteria: FindingCriteria? = null
        override var id: String? = null
        override var name: String? = null
        override var position: Int? = null
        override var tags: Map<String, String>? = null

        constructor(x: GetFindingsFilterResponse) : this() {
            this.action = x.action
            this.arn = x.arn
            this.description = x.description
            this.findingCriteria = x.findingCriteria
            this.id = x.id
            this.name = x.name
            this.position = x.position
            this.tags = x.tags
        }

        override fun build(): GetFindingsFilterResponse = GetFindingsFilterResponse(this)
        override fun action(action: FindingsFilterAction): FluentBuilder = apply { this.action = action }
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun findingCriteria(findingCriteria: FindingCriteria): FluentBuilder = apply { this.findingCriteria = findingCriteria }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun position(position: Int): FluentBuilder = apply { this.position = position }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
