// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model

import aws.smithy.kotlin.runtime.time.Instant

class GetMacieSessionResponse private constructor(builder: BuilderImpl) {
    /**
     * The date and time, in UTC and extended ISO 8601 format, when the Amazon Macie account was created.
     */
    val createdAt: Instant? = builder.createdAt
    /**
     * The frequency with which Macie publishes updates to policy findings for the account. This includes publishing updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events).
     */
    val findingPublishingFrequency: FindingPublishingFrequency? = builder.findingPublishingFrequency
    /**
     * The Amazon Resource Name (ARN) of the service-linked role that allows Macie to monitor and analyze data in Amazon Web Services resources for the account.
     */
    val serviceRole: String? = builder.serviceRole
    /**
     * The current status of the Macie account. Possible values are: PAUSED, the account is enabled but all Macie activities are suspended (paused) for the account; and, ENABLED, the account is enabled and all Macie activities are enabled for the account.
     */
    val status: MacieStatus? = builder.status
    /**
     * The date and time, in UTC and extended ISO 8601 format, of the most recent change to the status of the Macie account.
     */
    val updatedAt: Instant? = builder.updatedAt

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GetMacieSessionResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GetMacieSessionResponse(")
        append("createdAt=$createdAt,")
        append("findingPublishingFrequency=$findingPublishingFrequency,")
        append("serviceRole=$serviceRole,")
        append("status=$status,")
        append("updatedAt=$updatedAt)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (findingPublishingFrequency?.hashCode() ?: 0)
        result = 31 * result + (serviceRole?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetMacieSessionResponse

        if (createdAt != other.createdAt) return false
        if (findingPublishingFrequency != other.findingPublishingFrequency) return false
        if (serviceRole != other.serviceRole) return false
        if (status != other.status) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GetMacieSessionResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GetMacieSessionResponse
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the Amazon Macie account was created.
         */
        fun createdAt(createdAt: Instant): FluentBuilder
        /**
         * The frequency with which Macie publishes updates to policy findings for the account. This includes publishing updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events).
         */
        fun findingPublishingFrequency(findingPublishingFrequency: FindingPublishingFrequency): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the service-linked role that allows Macie to monitor and analyze data in Amazon Web Services resources for the account.
         */
        fun serviceRole(serviceRole: String): FluentBuilder
        /**
         * The current status of the Macie account. Possible values are: PAUSED, the account is enabled but all Macie activities are suspended (paused) for the account; and, ENABLED, the account is enabled and all Macie activities are enabled for the account.
         */
        fun status(status: MacieStatus): FluentBuilder
        /**
         * The date and time, in UTC and extended ISO 8601 format, of the most recent change to the status of the Macie account.
         */
        fun updatedAt(updatedAt: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the Amazon Macie account was created.
         */
        var createdAt: Instant?
        /**
         * The frequency with which Macie publishes updates to policy findings for the account. This includes publishing updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events).
         */
        var findingPublishingFrequency: FindingPublishingFrequency?
        /**
         * The Amazon Resource Name (ARN) of the service-linked role that allows Macie to monitor and analyze data in Amazon Web Services resources for the account.
         */
        var serviceRole: String?
        /**
         * The current status of the Macie account. Possible values are: PAUSED, the account is enabled but all Macie activities are suspended (paused) for the account; and, ENABLED, the account is enabled and all Macie activities are enabled for the account.
         */
        var status: MacieStatus?
        /**
         * The date and time, in UTC and extended ISO 8601 format, of the most recent change to the status of the Macie account.
         */
        var updatedAt: Instant?

        fun build(): GetMacieSessionResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var createdAt: Instant? = null
        override var findingPublishingFrequency: FindingPublishingFrequency? = null
        override var serviceRole: String? = null
        override var status: MacieStatus? = null
        override var updatedAt: Instant? = null

        constructor(x: GetMacieSessionResponse) : this() {
            this.createdAt = x.createdAt
            this.findingPublishingFrequency = x.findingPublishingFrequency
            this.serviceRole = x.serviceRole
            this.status = x.status
            this.updatedAt = x.updatedAt
        }

        override fun build(): GetMacieSessionResponse = GetMacieSessionResponse(this)
        override fun createdAt(createdAt: Instant): FluentBuilder = apply { this.createdAt = createdAt }
        override fun findingPublishingFrequency(findingPublishingFrequency: FindingPublishingFrequency): FluentBuilder = apply { this.findingPublishingFrequency = findingPublishingFrequency }
        override fun serviceRole(serviceRole: String): FluentBuilder = apply { this.serviceRole = serviceRole }
        override fun status(status: MacieStatus): FluentBuilder = apply { this.status = status }
        override fun updatedAt(updatedAt: Instant): FluentBuilder = apply { this.updatedAt = updatedAt }
    }
}
