// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model

import aws.smithy.kotlin.runtime.time.Instant

class GetMemberResponse private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Web Services account ID for the account.
     */
    val accountId: String? = builder.accountId
    /**
     * The Amazon Web Services account ID for the administrator account.
     */
    val administratorAccountId: String? = builder.administratorAccountId
    /**
     * The Amazon Resource Name (ARN) of the account.
     */
    val arn: String? = builder.arn
    /**
     * The email address for the account.
     */
    val email: String? = builder.email
    /**
     * The date and time, in UTC and extended ISO 8601 format, when an Amazon Macie membership invitation was last sent to the account. This value is null if a Macie invitation hasn't been sent to the account.
     */
    val invitedAt: Instant? = builder.invitedAt
    /**
     * (Deprecated) The Amazon Web Services account ID for the administrator account. This property has been replaced by the administratorAccountId property and is retained only for backward compatibility.
     */
    val masterAccountId: String? = builder.masterAccountId
    /**
     * The current status of the relationship between the account and the administrator account.
     */
    val relationshipStatus: RelationshipStatus? = builder.relationshipStatus
    /**
     * A map of key-value pairs that identifies the tags (keys and values) that are associated with the member account in Amazon Macie.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The date and time, in UTC and extended ISO 8601 format, of the most recent change to the status of the relationship between the account and the administrator account.
     */
    val updatedAt: Instant? = builder.updatedAt

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GetMemberResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GetMemberResponse(")
        append("accountId=$accountId,")
        append("administratorAccountId=$administratorAccountId,")
        append("arn=$arn,")
        append("email=$email,")
        append("invitedAt=$invitedAt,")
        append("masterAccountId=$masterAccountId,")
        append("relationshipStatus=$relationshipStatus,")
        append("tags=$tags,")
        append("updatedAt=$updatedAt)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (administratorAccountId?.hashCode() ?: 0)
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (email?.hashCode() ?: 0)
        result = 31 * result + (invitedAt?.hashCode() ?: 0)
        result = 31 * result + (masterAccountId?.hashCode() ?: 0)
        result = 31 * result + (relationshipStatus?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetMemberResponse

        if (accountId != other.accountId) return false
        if (administratorAccountId != other.administratorAccountId) return false
        if (arn != other.arn) return false
        if (email != other.email) return false
        if (invitedAt != other.invitedAt) return false
        if (masterAccountId != other.masterAccountId) return false
        if (relationshipStatus != other.relationshipStatus) return false
        if (tags != other.tags) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GetMemberResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GetMemberResponse
        /**
         * The Amazon Web Services account ID for the account.
         */
        fun accountId(accountId: String): FluentBuilder
        /**
         * The Amazon Web Services account ID for the administrator account.
         */
        fun administratorAccountId(administratorAccountId: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the account.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The email address for the account.
         */
        fun email(email: String): FluentBuilder
        /**
         * The date and time, in UTC and extended ISO 8601 format, when an Amazon Macie membership invitation was last sent to the account. This value is null if a Macie invitation hasn't been sent to the account.
         */
        fun invitedAt(invitedAt: Instant): FluentBuilder
        /**
         * (Deprecated) The Amazon Web Services account ID for the administrator account. This property has been replaced by the administratorAccountId property and is retained only for backward compatibility.
         */
        fun masterAccountId(masterAccountId: String): FluentBuilder
        /**
         * The current status of the relationship between the account and the administrator account.
         */
        fun relationshipStatus(relationshipStatus: RelationshipStatus): FluentBuilder
        /**
         * A map of key-value pairs that identifies the tags (keys and values) that are associated with the member account in Amazon Macie.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * The date and time, in UTC and extended ISO 8601 format, of the most recent change to the status of the relationship between the account and the administrator account.
         */
        fun updatedAt(updatedAt: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Web Services account ID for the account.
         */
        var accountId: String?
        /**
         * The Amazon Web Services account ID for the administrator account.
         */
        var administratorAccountId: String?
        /**
         * The Amazon Resource Name (ARN) of the account.
         */
        var arn: String?
        /**
         * The email address for the account.
         */
        var email: String?
        /**
         * The date and time, in UTC and extended ISO 8601 format, when an Amazon Macie membership invitation was last sent to the account. This value is null if a Macie invitation hasn't been sent to the account.
         */
        var invitedAt: Instant?
        /**
         * (Deprecated) The Amazon Web Services account ID for the administrator account. This property has been replaced by the administratorAccountId property and is retained only for backward compatibility.
         */
        var masterAccountId: String?
        /**
         * The current status of the relationship between the account and the administrator account.
         */
        var relationshipStatus: RelationshipStatus?
        /**
         * A map of key-value pairs that identifies the tags (keys and values) that are associated with the member account in Amazon Macie.
         */
        var tags: Map<String, String>?
        /**
         * The date and time, in UTC and extended ISO 8601 format, of the most recent change to the status of the relationship between the account and the administrator account.
         */
        var updatedAt: Instant?

        fun build(): GetMemberResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accountId: String? = null
        override var administratorAccountId: String? = null
        override var arn: String? = null
        override var email: String? = null
        override var invitedAt: Instant? = null
        override var masterAccountId: String? = null
        override var relationshipStatus: RelationshipStatus? = null
        override var tags: Map<String, String>? = null
        override var updatedAt: Instant? = null

        constructor(x: GetMemberResponse) : this() {
            this.accountId = x.accountId
            this.administratorAccountId = x.administratorAccountId
            this.arn = x.arn
            this.email = x.email
            this.invitedAt = x.invitedAt
            this.masterAccountId = x.masterAccountId
            this.relationshipStatus = x.relationshipStatus
            this.tags = x.tags
            this.updatedAt = x.updatedAt
        }

        override fun build(): GetMemberResponse = GetMemberResponse(this)
        override fun accountId(accountId: String): FluentBuilder = apply { this.accountId = accountId }
        override fun administratorAccountId(administratorAccountId: String): FluentBuilder = apply { this.administratorAccountId = administratorAccountId }
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun email(email: String): FluentBuilder = apply { this.email = email }
        override fun invitedAt(invitedAt: Instant): FluentBuilder = apply { this.invitedAt = invitedAt }
        override fun masterAccountId(masterAccountId: String): FluentBuilder = apply { this.masterAccountId = masterAccountId }
        override fun relationshipStatus(relationshipStatus: RelationshipStatus): FluentBuilder = apply { this.relationshipStatus = relationshipStatus }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun updatedAt(updatedAt: Instant): FluentBuilder = apply { this.updatedAt = updatedAt }
    }
}
