// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about an Identity and Access Management (IAM) user who performed an action on an affected resource.
 */
class IamUser private constructor(builder: BuilderImpl) {
    /**
     * The unique identifier for the Amazon Web Services account that's associated with the IAM user who performed the action.
     */
    val accountId: String? = builder.accountId
    /**
     * The Amazon Resource Name (ARN) of the principal that performed the action. The last section of the ARN contains the name of the user who performed the action.
     */
    val arn: String? = builder.arn
    /**
     * The unique identifier for the IAM user who performed the action.
     */
    val principalId: String? = builder.principalId
    /**
     * The user name of the IAM user who performed the action.
     */
    val userName: String? = builder.userName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): IamUser = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("IamUser(")
        append("accountId=$accountId,")
        append("arn=$arn,")
        append("principalId=$principalId,")
        append("userName=$userName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (principalId?.hashCode() ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as IamUser

        if (accountId != other.accountId) return false
        if (arn != other.arn) return false
        if (principalId != other.principalId) return false
        if (userName != other.userName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): IamUser = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): IamUser
        /**
         * The unique identifier for the Amazon Web Services account that's associated with the IAM user who performed the action.
         */
        fun accountId(accountId: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the principal that performed the action. The last section of the ARN contains the name of the user who performed the action.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The unique identifier for the IAM user who performed the action.
         */
        fun principalId(principalId: String): FluentBuilder
        /**
         * The user name of the IAM user who performed the action.
         */
        fun userName(userName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The unique identifier for the Amazon Web Services account that's associated with the IAM user who performed the action.
         */
        var accountId: String?
        /**
         * The Amazon Resource Name (ARN) of the principal that performed the action. The last section of the ARN contains the name of the user who performed the action.
         */
        var arn: String?
        /**
         * The unique identifier for the IAM user who performed the action.
         */
        var principalId: String?
        /**
         * The user name of the IAM user who performed the action.
         */
        var userName: String?

        fun build(): IamUser
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accountId: String? = null
        override var arn: String? = null
        override var principalId: String? = null
        override var userName: String? = null

        constructor(x: IamUser) : this() {
            this.accountId = x.accountId
            this.arn = x.arn
            this.principalId = x.principalId
            this.userName = x.userName
        }

        override fun build(): IamUser = IamUser(this)
        override fun accountId(accountId: String): FluentBuilder = apply { this.accountId = accountId }
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun principalId(principalId: String): FluentBuilder = apply { this.principalId = principalId }
        override fun userName(userName: String): FluentBuilder = apply { this.userName = userName }
    }
}
