// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information about an Amazon Macie membership invitation that was received by an account.
 */
class Invitation private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Web Services account ID for the account that sent the invitation.
     */
    val accountId: String? = builder.accountId
    /**
     * The unique identifier for the invitation. Amazon Macie uses this identifier to validate the inviter account with the invitee account.
     */
    val invitationId: String? = builder.invitationId
    /**
     * The date and time, in UTC and extended ISO 8601 format, when the invitation was sent.
     */
    val invitedAt: Instant? = builder.invitedAt
    /**
     * The status of the relationship between the account that sent the invitation (inviter account) and the account that received the invitation (invitee account).
     */
    val relationshipStatus: RelationshipStatus? = builder.relationshipStatus

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Invitation = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Invitation(")
        append("accountId=$accountId,")
        append("invitationId=$invitationId,")
        append("invitedAt=$invitedAt,")
        append("relationshipStatus=$relationshipStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (invitationId?.hashCode() ?: 0)
        result = 31 * result + (invitedAt?.hashCode() ?: 0)
        result = 31 * result + (relationshipStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Invitation

        if (accountId != other.accountId) return false
        if (invitationId != other.invitationId) return false
        if (invitedAt != other.invitedAt) return false
        if (relationshipStatus != other.relationshipStatus) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Invitation = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Invitation
        /**
         * The Amazon Web Services account ID for the account that sent the invitation.
         */
        fun accountId(accountId: String): FluentBuilder
        /**
         * The unique identifier for the invitation. Amazon Macie uses this identifier to validate the inviter account with the invitee account.
         */
        fun invitationId(invitationId: String): FluentBuilder
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the invitation was sent.
         */
        fun invitedAt(invitedAt: Instant): FluentBuilder
        /**
         * The status of the relationship between the account that sent the invitation (inviter account) and the account that received the invitation (invitee account).
         */
        fun relationshipStatus(relationshipStatus: RelationshipStatus): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Web Services account ID for the account that sent the invitation.
         */
        var accountId: String?
        /**
         * The unique identifier for the invitation. Amazon Macie uses this identifier to validate the inviter account with the invitee account.
         */
        var invitationId: String?
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the invitation was sent.
         */
        var invitedAt: Instant?
        /**
         * The status of the relationship between the account that sent the invitation (inviter account) and the account that received the invitation (invitee account).
         */
        var relationshipStatus: RelationshipStatus?

        fun build(): Invitation
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accountId: String? = null
        override var invitationId: String? = null
        override var invitedAt: Instant? = null
        override var relationshipStatus: RelationshipStatus? = null

        constructor(x: Invitation) : this() {
            this.accountId = x.accountId
            this.invitationId = x.invitationId
            this.invitedAt = x.invitedAt
            this.relationshipStatus = x.relationshipStatus
        }

        override fun build(): Invitation = Invitation(this)
        override fun accountId(accountId: String): FluentBuilder = apply { this.accountId = accountId }
        override fun invitationId(invitationId: String): FluentBuilder = apply { this.invitationId = invitationId }
        override fun invitedAt(invitedAt: Instant): FluentBuilder = apply { this.invitedAt = invitedAt }
        override fun relationshipStatus(relationshipStatus: RelationshipStatus): FluentBuilder = apply { this.relationshipStatus = relationshipStatus }
    }
}
