// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about the IP address of the device that an entity used to perform an action on an affected resource.
 */
class IpAddressDetails private constructor(builder: BuilderImpl) {
    /**
     * The Internet Protocol version 4 (IPv4) address of the device.
     */
    val ipAddressV4: String? = builder.ipAddressV4
    /**
     * The city that the IP address originated from.
     */
    val ipCity: IpCity? = builder.ipCity
    /**
     * The country that the IP address originated from.
     */
    val ipCountry: IpCountry? = builder.ipCountry
    /**
     * The geographic coordinates of the location that the IP address originated from.
     */
    val ipGeoLocation: IpGeoLocation? = builder.ipGeoLocation
    /**
     * The registered owner of the IP address.
     */
    val ipOwner: IpOwner? = builder.ipOwner

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): IpAddressDetails = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("IpAddressDetails(")
        append("ipAddressV4=$ipAddressV4,")
        append("ipCity=$ipCity,")
        append("ipCountry=$ipCountry,")
        append("ipGeoLocation=$ipGeoLocation,")
        append("ipOwner=$ipOwner)")
    }

    override fun hashCode(): kotlin.Int {
        var result = ipAddressV4?.hashCode() ?: 0
        result = 31 * result + (ipCity?.hashCode() ?: 0)
        result = 31 * result + (ipCountry?.hashCode() ?: 0)
        result = 31 * result + (ipGeoLocation?.hashCode() ?: 0)
        result = 31 * result + (ipOwner?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as IpAddressDetails

        if (ipAddressV4 != other.ipAddressV4) return false
        if (ipCity != other.ipCity) return false
        if (ipCountry != other.ipCountry) return false
        if (ipGeoLocation != other.ipGeoLocation) return false
        if (ipOwner != other.ipOwner) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): IpAddressDetails = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): IpAddressDetails
        /**
         * The Internet Protocol version 4 (IPv4) address of the device.
         */
        fun ipAddressV4(ipAddressV4: String): FluentBuilder
        /**
         * The city that the IP address originated from.
         */
        fun ipCity(ipCity: IpCity): FluentBuilder
        /**
         * The country that the IP address originated from.
         */
        fun ipCountry(ipCountry: IpCountry): FluentBuilder
        /**
         * The geographic coordinates of the location that the IP address originated from.
         */
        fun ipGeoLocation(ipGeoLocation: IpGeoLocation): FluentBuilder
        /**
         * The registered owner of the IP address.
         */
        fun ipOwner(ipOwner: IpOwner): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Internet Protocol version 4 (IPv4) address of the device.
         */
        var ipAddressV4: String?
        /**
         * The city that the IP address originated from.
         */
        var ipCity: IpCity?
        /**
         * The country that the IP address originated from.
         */
        var ipCountry: IpCountry?
        /**
         * The geographic coordinates of the location that the IP address originated from.
         */
        var ipGeoLocation: IpGeoLocation?
        /**
         * The registered owner of the IP address.
         */
        var ipOwner: IpOwner?

        fun build(): IpAddressDetails
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.IpCity] inside the given [block]
         */
        fun ipCity(block: IpCity.DslBuilder.() -> kotlin.Unit) {
            this.ipCity = IpCity.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.IpCountry] inside the given [block]
         */
        fun ipCountry(block: IpCountry.DslBuilder.() -> kotlin.Unit) {
            this.ipCountry = IpCountry.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.IpGeoLocation] inside the given [block]
         */
        fun ipGeoLocation(block: IpGeoLocation.DslBuilder.() -> kotlin.Unit) {
            this.ipGeoLocation = IpGeoLocation.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.IpOwner] inside the given [block]
         */
        fun ipOwner(block: IpOwner.DslBuilder.() -> kotlin.Unit) {
            this.ipOwner = IpOwner.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var ipAddressV4: String? = null
        override var ipCity: IpCity? = null
        override var ipCountry: IpCountry? = null
        override var ipGeoLocation: IpGeoLocation? = null
        override var ipOwner: IpOwner? = null

        constructor(x: IpAddressDetails) : this() {
            this.ipAddressV4 = x.ipAddressV4
            this.ipCity = x.ipCity
            this.ipCountry = x.ipCountry
            this.ipGeoLocation = x.ipGeoLocation
            this.ipOwner = x.ipOwner
        }

        override fun build(): IpAddressDetails = IpAddressDetails(this)
        override fun ipAddressV4(ipAddressV4: String): FluentBuilder = apply { this.ipAddressV4 = ipAddressV4 }
        override fun ipCity(ipCity: IpCity): FluentBuilder = apply { this.ipCity = ipCity }
        override fun ipCountry(ipCountry: IpCountry): FluentBuilder = apply { this.ipCountry = ipCountry }
        override fun ipGeoLocation(ipGeoLocation: IpGeoLocation): FluentBuilder = apply { this.ipGeoLocation = ipGeoLocation }
        override fun ipOwner(ipOwner: IpOwner): FluentBuilder = apply { this.ipOwner = ipOwner }
    }
}
