// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about the registered owner of an IP address.
 */
class IpOwner private constructor(builder: BuilderImpl) {
    /**
     * The autonomous system number (ASN) for the autonomous system that included the IP address.
     */
    val asn: String? = builder.asn
    /**
     * The organization identifier that's associated with the autonomous system number (ASN) for the autonomous system that included the IP address.
     */
    val asnOrg: String? = builder.asnOrg
    /**
     * The name of the internet service provider (ISP) that owned the IP address.
     */
    val isp: String? = builder.isp
    /**
     * The name of the organization that owned the IP address.
     */
    val org: String? = builder.org

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): IpOwner = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("IpOwner(")
        append("asn=$asn,")
        append("asnOrg=$asnOrg,")
        append("isp=$isp,")
        append("org=$org)")
    }

    override fun hashCode(): kotlin.Int {
        var result = asn?.hashCode() ?: 0
        result = 31 * result + (asnOrg?.hashCode() ?: 0)
        result = 31 * result + (isp?.hashCode() ?: 0)
        result = 31 * result + (org?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as IpOwner

        if (asn != other.asn) return false
        if (asnOrg != other.asnOrg) return false
        if (isp != other.isp) return false
        if (org != other.org) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): IpOwner = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): IpOwner
        /**
         * The autonomous system number (ASN) for the autonomous system that included the IP address.
         */
        fun asn(asn: String): FluentBuilder
        /**
         * The organization identifier that's associated with the autonomous system number (ASN) for the autonomous system that included the IP address.
         */
        fun asnOrg(asnOrg: String): FluentBuilder
        /**
         * The name of the internet service provider (ISP) that owned the IP address.
         */
        fun isp(isp: String): FluentBuilder
        /**
         * The name of the organization that owned the IP address.
         */
        fun org(org: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The autonomous system number (ASN) for the autonomous system that included the IP address.
         */
        var asn: String?
        /**
         * The organization identifier that's associated with the autonomous system number (ASN) for the autonomous system that included the IP address.
         */
        var asnOrg: String?
        /**
         * The name of the internet service provider (ISP) that owned the IP address.
         */
        var isp: String?
        /**
         * The name of the organization that owned the IP address.
         */
        var org: String?

        fun build(): IpOwner
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var asn: String? = null
        override var asnOrg: String? = null
        override var isp: String? = null
        override var org: String? = null

        constructor(x: IpOwner) : this() {
            this.asn = x.asn
            this.asnOrg = x.asnOrg
            this.isp = x.isp
            this.org = x.org
        }

        override fun build(): IpOwner = IpOwner(this)
        override fun asn(asn: String): FluentBuilder = apply { this.asn = asn }
        override fun asnOrg(asnOrg: String): FluentBuilder = apply { this.asnOrg = asnOrg }
        override fun isp(isp: String): FluentBuilder = apply { this.isp = isp }
        override fun org(org: String): FluentBuilder = apply { this.org = org }
    }
}
