// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Specifies whether any one-time or recurring classification jobs are configured to analyze data in an S3 bucket, and, if so, the details of the job that ran most recently.
 */
class JobDetails private constructor(builder: BuilderImpl) {
    /**
     * Specifies whether any one-time or recurring jobs are configured to analyze data in the bucket. Possible values are: TRUE - The bucket is explicitly included in the bucket definition (S3BucketDefinitionForJob) for one or more jobs and at least one of those jobs has a status other than CANCELLED. Or the bucket matched the bucket criteria (S3BucketCriteriaForJob) for at least one job that previously ran. FALSE - The bucket isn't explicitly included in the bucket definition (S3BucketDefinitionForJob) for any jobs, all the jobs that explicitly include the bucket in their bucket definitions have a status of CANCELLED, or the bucket didn't match the bucket criteria (S3BucketCriteriaForJob) for any jobs that previously ran. UNKNOWN - An exception occurred when Amazon Macie attempted to retrieve job data for the bucket.
     */
    val isDefinedInJob: IsDefinedInJob? = builder.isDefinedInJob
    /**
     * Specifies whether any recurring jobs are configured to analyze data in the bucket. Possible values are: TRUE - The bucket is explicitly included in the bucket definition (S3BucketDefinitionForJob) for one or more recurring jobs or the bucket matches the bucket criteria (S3BucketCriteriaForJob) for one or more recurring jobs. At least one of those jobs has a status other than CANCELLED. FALSE - The bucket isn't explicitly included in the bucket definition (S3BucketDefinitionForJob) for any recurring jobs, the bucket doesn't match the bucket criteria (S3BucketCriteriaForJob) for any recurring jobs, or all the recurring jobs that are configured to analyze data in the bucket have a status of CANCELLED. UNKNOWN - An exception occurred when Amazon Macie attempted to retrieve job data for the bucket.
     */
    val isMonitoredByJob: IsMonitoredByJob? = builder.isMonitoredByJob
    /**
     * The unique identifier for the job that ran most recently and is configured to analyze data in the bucket, either the latest run of a recurring job or the only run of a one-time job. This value is typically null if the value for the isDefinedInJob property is FALSE or UNKNOWN.
     */
    val lastJobId: String? = builder.lastJobId
    /**
     * The date and time, in UTC and extended ISO 8601 format, when the job (lastJobId) started. If the job is a recurring job, this value indicates when the most recent run started. This value is typically null if the value for the isDefinedInJob property is FALSE or UNKNOWN.
     */
    val lastJobRunTime: Instant? = builder.lastJobRunTime

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): JobDetails = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("JobDetails(")
        append("isDefinedInJob=$isDefinedInJob,")
        append("isMonitoredByJob=$isMonitoredByJob,")
        append("lastJobId=$lastJobId,")
        append("lastJobRunTime=$lastJobRunTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = isDefinedInJob?.hashCode() ?: 0
        result = 31 * result + (isMonitoredByJob?.hashCode() ?: 0)
        result = 31 * result + (lastJobId?.hashCode() ?: 0)
        result = 31 * result + (lastJobRunTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as JobDetails

        if (isDefinedInJob != other.isDefinedInJob) return false
        if (isMonitoredByJob != other.isMonitoredByJob) return false
        if (lastJobId != other.lastJobId) return false
        if (lastJobRunTime != other.lastJobRunTime) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): JobDetails = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): JobDetails
        /**
         * Specifies whether any one-time or recurring jobs are configured to analyze data in the bucket. Possible values are: TRUE - The bucket is explicitly included in the bucket definition (S3BucketDefinitionForJob) for one or more jobs and at least one of those jobs has a status other than CANCELLED. Or the bucket matched the bucket criteria (S3BucketCriteriaForJob) for at least one job that previously ran. FALSE - The bucket isn't explicitly included in the bucket definition (S3BucketDefinitionForJob) for any jobs, all the jobs that explicitly include the bucket in their bucket definitions have a status of CANCELLED, or the bucket didn't match the bucket criteria (S3BucketCriteriaForJob) for any jobs that previously ran. UNKNOWN - An exception occurred when Amazon Macie attempted to retrieve job data for the bucket.
         */
        fun isDefinedInJob(isDefinedInJob: IsDefinedInJob): FluentBuilder
        /**
         * Specifies whether any recurring jobs are configured to analyze data in the bucket. Possible values are: TRUE - The bucket is explicitly included in the bucket definition (S3BucketDefinitionForJob) for one or more recurring jobs or the bucket matches the bucket criteria (S3BucketCriteriaForJob) for one or more recurring jobs. At least one of those jobs has a status other than CANCELLED. FALSE - The bucket isn't explicitly included in the bucket definition (S3BucketDefinitionForJob) for any recurring jobs, the bucket doesn't match the bucket criteria (S3BucketCriteriaForJob) for any recurring jobs, or all the recurring jobs that are configured to analyze data in the bucket have a status of CANCELLED. UNKNOWN - An exception occurred when Amazon Macie attempted to retrieve job data for the bucket.
         */
        fun isMonitoredByJob(isMonitoredByJob: IsMonitoredByJob): FluentBuilder
        /**
         * The unique identifier for the job that ran most recently and is configured to analyze data in the bucket, either the latest run of a recurring job or the only run of a one-time job. This value is typically null if the value for the isDefinedInJob property is FALSE or UNKNOWN.
         */
        fun lastJobId(lastJobId: String): FluentBuilder
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the job (lastJobId) started. If the job is a recurring job, this value indicates when the most recent run started. This value is typically null if the value for the isDefinedInJob property is FALSE or UNKNOWN.
         */
        fun lastJobRunTime(lastJobRunTime: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specifies whether any one-time or recurring jobs are configured to analyze data in the bucket. Possible values are: TRUE - The bucket is explicitly included in the bucket definition (S3BucketDefinitionForJob) for one or more jobs and at least one of those jobs has a status other than CANCELLED. Or the bucket matched the bucket criteria (S3BucketCriteriaForJob) for at least one job that previously ran. FALSE - The bucket isn't explicitly included in the bucket definition (S3BucketDefinitionForJob) for any jobs, all the jobs that explicitly include the bucket in their bucket definitions have a status of CANCELLED, or the bucket didn't match the bucket criteria (S3BucketCriteriaForJob) for any jobs that previously ran. UNKNOWN - An exception occurred when Amazon Macie attempted to retrieve job data for the bucket.
         */
        var isDefinedInJob: IsDefinedInJob?
        /**
         * Specifies whether any recurring jobs are configured to analyze data in the bucket. Possible values are: TRUE - The bucket is explicitly included in the bucket definition (S3BucketDefinitionForJob) for one or more recurring jobs or the bucket matches the bucket criteria (S3BucketCriteriaForJob) for one or more recurring jobs. At least one of those jobs has a status other than CANCELLED. FALSE - The bucket isn't explicitly included in the bucket definition (S3BucketDefinitionForJob) for any recurring jobs, the bucket doesn't match the bucket criteria (S3BucketCriteriaForJob) for any recurring jobs, or all the recurring jobs that are configured to analyze data in the bucket have a status of CANCELLED. UNKNOWN - An exception occurred when Amazon Macie attempted to retrieve job data for the bucket.
         */
        var isMonitoredByJob: IsMonitoredByJob?
        /**
         * The unique identifier for the job that ran most recently and is configured to analyze data in the bucket, either the latest run of a recurring job or the only run of a one-time job. This value is typically null if the value for the isDefinedInJob property is FALSE or UNKNOWN.
         */
        var lastJobId: String?
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the job (lastJobId) started. If the job is a recurring job, this value indicates when the most recent run started. This value is typically null if the value for the isDefinedInJob property is FALSE or UNKNOWN.
         */
        var lastJobRunTime: Instant?

        fun build(): JobDetails
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var isDefinedInJob: IsDefinedInJob? = null
        override var isMonitoredByJob: IsMonitoredByJob? = null
        override var lastJobId: String? = null
        override var lastJobRunTime: Instant? = null

        constructor(x: JobDetails) : this() {
            this.isDefinedInJob = x.isDefinedInJob
            this.isMonitoredByJob = x.isMonitoredByJob
            this.lastJobId = x.lastJobId
            this.lastJobRunTime = x.lastJobRunTime
        }

        override fun build(): JobDetails = JobDetails(this)
        override fun isDefinedInJob(isDefinedInJob: IsDefinedInJob): FluentBuilder = apply { this.isDefinedInJob = isDefinedInJob }
        override fun isMonitoredByJob(isMonitoredByJob: IsMonitoredByJob): FluentBuilder = apply { this.isMonitoredByJob = isMonitoredByJob }
        override fun lastJobId(lastJobId: String): FluentBuilder = apply { this.lastJobId = lastJobId }
        override fun lastJobRunTime(lastJobRunTime: Instant): FluentBuilder = apply { this.lastJobRunTime = lastJobRunTime }
    }
}
