// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information about a classification job, including the current status of the job.
 */
class JobSummary private constructor(builder: BuilderImpl) {
    /**
     * The property- and tag-based conditions that determine which S3 buckets are included or excluded from the job's analysis. Each time the job runs, the job uses these criteria to determine which buckets to analyze. A job's definition can contain a bucketCriteria object or a bucketDefinitions array, not both.
     */
    val bucketCriteria: S3BucketCriteriaForJob? = builder.bucketCriteria
    /**
     * An array of objects, one for each Amazon Web Services account that owns specific S3 buckets for the job to analyze. Each object specifies the account ID for an account and one or more buckets to analyze for that account. A job's definition can contain a bucketDefinitions array or a bucketCriteria object, not both.
     */
    val bucketDefinitions: List<S3BucketDefinitionForJob>? = builder.bucketDefinitions
    /**
     * The date and time, in UTC and extended ISO 8601 format, when the job was created.
     */
    val createdAt: Instant? = builder.createdAt
    /**
     * The unique identifier for the job.
     */
    val jobId: String? = builder.jobId
    /**
     * The current status of the job. Possible values are: CANCELLED - You cancelled the job or, if it's a one-time job, you paused the job and didn't resume it within 30 days. COMPLETE - For a one-time job, Amazon Macie finished processing the data specified for the job. This value doesn't apply to recurring jobs. IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is pending. This value doesn't apply to one-time jobs. PAUSED - Amazon Macie started running the job but additional processing would exceed the monthly sensitive data discovery quota for your account or one or more member accounts that the job analyzes data for. RUNNING - For a one-time job, the job is in progress. For a recurring job, a scheduled run is in progress. USER_PAUSED - You paused the job. If you paused the job while it had a status of RUNNING and you don't resume it within 30 days of pausing it, the job or job run will expire and be cancelled, depending on the job's type. To check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.
     */
    val jobStatus: JobStatus? = builder.jobStatus
    /**
     * The schedule for running the job. Possible values are: ONE_TIME - The job runs only once. SCHEDULED - The job runs on a daily, weekly, or monthly basis.
     */
    val jobType: JobType? = builder.jobType
    /**
     * Specifies whether any account- or bucket-level access errors occurred when the job ran. For a recurring job, this value indicates the error status of the job's most recent run.
     */
    val lastRunErrorStatus: LastRunErrorStatus? = builder.lastRunErrorStatus
    /**
     * The custom name of the job.
     */
    val name: String? = builder.name
    /**
     * If the current status of the job is USER_PAUSED, specifies when the job was paused and when the job or job run will expire and be cancelled if it isn't resumed. This value is present only if the value for jobStatus is USER_PAUSED.
     */
    val userPausedDetails: UserPausedDetails? = builder.userPausedDetails

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): JobSummary = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("JobSummary(")
        append("bucketCriteria=$bucketCriteria,")
        append("bucketDefinitions=$bucketDefinitions,")
        append("createdAt=$createdAt,")
        append("jobId=$jobId,")
        append("jobStatus=$jobStatus,")
        append("jobType=$jobType,")
        append("lastRunErrorStatus=$lastRunErrorStatus,")
        append("name=$name,")
        append("userPausedDetails=$userPausedDetails)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketCriteria?.hashCode() ?: 0
        result = 31 * result + (bucketDefinitions?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (jobStatus?.hashCode() ?: 0)
        result = 31 * result + (jobType?.hashCode() ?: 0)
        result = 31 * result + (lastRunErrorStatus?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (userPausedDetails?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as JobSummary

        if (bucketCriteria != other.bucketCriteria) return false
        if (bucketDefinitions != other.bucketDefinitions) return false
        if (createdAt != other.createdAt) return false
        if (jobId != other.jobId) return false
        if (jobStatus != other.jobStatus) return false
        if (jobType != other.jobType) return false
        if (lastRunErrorStatus != other.lastRunErrorStatus) return false
        if (name != other.name) return false
        if (userPausedDetails != other.userPausedDetails) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): JobSummary = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): JobSummary
        /**
         * The property- and tag-based conditions that determine which S3 buckets are included or excluded from the job's analysis. Each time the job runs, the job uses these criteria to determine which buckets to analyze. A job's definition can contain a bucketCriteria object or a bucketDefinitions array, not both.
         */
        fun bucketCriteria(bucketCriteria: S3BucketCriteriaForJob): FluentBuilder
        /**
         * An array of objects, one for each Amazon Web Services account that owns specific S3 buckets for the job to analyze. Each object specifies the account ID for an account and one or more buckets to analyze for that account. A job's definition can contain a bucketDefinitions array or a bucketCriteria object, not both.
         */
        fun bucketDefinitions(bucketDefinitions: List<S3BucketDefinitionForJob>): FluentBuilder
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the job was created.
         */
        fun createdAt(createdAt: Instant): FluentBuilder
        /**
         * The unique identifier for the job.
         */
        fun jobId(jobId: String): FluentBuilder
        /**
         * The current status of the job. Possible values are: CANCELLED - You cancelled the job or, if it's a one-time job, you paused the job and didn't resume it within 30 days. COMPLETE - For a one-time job, Amazon Macie finished processing the data specified for the job. This value doesn't apply to recurring jobs. IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is pending. This value doesn't apply to one-time jobs. PAUSED - Amazon Macie started running the job but additional processing would exceed the monthly sensitive data discovery quota for your account or one or more member accounts that the job analyzes data for. RUNNING - For a one-time job, the job is in progress. For a recurring job, a scheduled run is in progress. USER_PAUSED - You paused the job. If you paused the job while it had a status of RUNNING and you don't resume it within 30 days of pausing it, the job or job run will expire and be cancelled, depending on the job's type. To check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.
         */
        fun jobStatus(jobStatus: JobStatus): FluentBuilder
        /**
         * The schedule for running the job. Possible values are: ONE_TIME - The job runs only once. SCHEDULED - The job runs on a daily, weekly, or monthly basis.
         */
        fun jobType(jobType: JobType): FluentBuilder
        /**
         * Specifies whether any account- or bucket-level access errors occurred when the job ran. For a recurring job, this value indicates the error status of the job's most recent run.
         */
        fun lastRunErrorStatus(lastRunErrorStatus: LastRunErrorStatus): FluentBuilder
        /**
         * The custom name of the job.
         */
        fun name(name: String): FluentBuilder
        /**
         * If the current status of the job is USER_PAUSED, specifies when the job was paused and when the job or job run will expire and be cancelled if it isn't resumed. This value is present only if the value for jobStatus is USER_PAUSED.
         */
        fun userPausedDetails(userPausedDetails: UserPausedDetails): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The property- and tag-based conditions that determine which S3 buckets are included or excluded from the job's analysis. Each time the job runs, the job uses these criteria to determine which buckets to analyze. A job's definition can contain a bucketCriteria object or a bucketDefinitions array, not both.
         */
        var bucketCriteria: S3BucketCriteriaForJob?
        /**
         * An array of objects, one for each Amazon Web Services account that owns specific S3 buckets for the job to analyze. Each object specifies the account ID for an account and one or more buckets to analyze for that account. A job's definition can contain a bucketDefinitions array or a bucketCriteria object, not both.
         */
        var bucketDefinitions: List<S3BucketDefinitionForJob>?
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the job was created.
         */
        var createdAt: Instant?
        /**
         * The unique identifier for the job.
         */
        var jobId: String?
        /**
         * The current status of the job. Possible values are: CANCELLED - You cancelled the job or, if it's a one-time job, you paused the job and didn't resume it within 30 days. COMPLETE - For a one-time job, Amazon Macie finished processing the data specified for the job. This value doesn't apply to recurring jobs. IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is pending. This value doesn't apply to one-time jobs. PAUSED - Amazon Macie started running the job but additional processing would exceed the monthly sensitive data discovery quota for your account or one or more member accounts that the job analyzes data for. RUNNING - For a one-time job, the job is in progress. For a recurring job, a scheduled run is in progress. USER_PAUSED - You paused the job. If you paused the job while it had a status of RUNNING and you don't resume it within 30 days of pausing it, the job or job run will expire and be cancelled, depending on the job's type. To check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.
         */
        var jobStatus: JobStatus?
        /**
         * The schedule for running the job. Possible values are: ONE_TIME - The job runs only once. SCHEDULED - The job runs on a daily, weekly, or monthly basis.
         */
        var jobType: JobType?
        /**
         * Specifies whether any account- or bucket-level access errors occurred when the job ran. For a recurring job, this value indicates the error status of the job's most recent run.
         */
        var lastRunErrorStatus: LastRunErrorStatus?
        /**
         * The custom name of the job.
         */
        var name: String?
        /**
         * If the current status of the job is USER_PAUSED, specifies when the job was paused and when the job or job run will expire and be cancelled if it isn't resumed. This value is present only if the value for jobStatus is USER_PAUSED.
         */
        var userPausedDetails: UserPausedDetails?

        fun build(): JobSummary
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.S3BucketCriteriaForJob] inside the given [block]
         */
        fun bucketCriteria(block: S3BucketCriteriaForJob.DslBuilder.() -> kotlin.Unit) {
            this.bucketCriteria = S3BucketCriteriaForJob.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.LastRunErrorStatus] inside the given [block]
         */
        fun lastRunErrorStatus(block: LastRunErrorStatus.DslBuilder.() -> kotlin.Unit) {
            this.lastRunErrorStatus = LastRunErrorStatus.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.UserPausedDetails] inside the given [block]
         */
        fun userPausedDetails(block: UserPausedDetails.DslBuilder.() -> kotlin.Unit) {
            this.userPausedDetails = UserPausedDetails.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var bucketCriteria: S3BucketCriteriaForJob? = null
        override var bucketDefinitions: List<S3BucketDefinitionForJob>? = null
        override var createdAt: Instant? = null
        override var jobId: String? = null
        override var jobStatus: JobStatus? = null
        override var jobType: JobType? = null
        override var lastRunErrorStatus: LastRunErrorStatus? = null
        override var name: String? = null
        override var userPausedDetails: UserPausedDetails? = null

        constructor(x: JobSummary) : this() {
            this.bucketCriteria = x.bucketCriteria
            this.bucketDefinitions = x.bucketDefinitions
            this.createdAt = x.createdAt
            this.jobId = x.jobId
            this.jobStatus = x.jobStatus
            this.jobType = x.jobType
            this.lastRunErrorStatus = x.lastRunErrorStatus
            this.name = x.name
            this.userPausedDetails = x.userPausedDetails
        }

        override fun build(): JobSummary = JobSummary(this)
        override fun bucketCriteria(bucketCriteria: S3BucketCriteriaForJob): FluentBuilder = apply { this.bucketCriteria = bucketCriteria }
        override fun bucketDefinitions(bucketDefinitions: List<S3BucketDefinitionForJob>): FluentBuilder = apply { this.bucketDefinitions = bucketDefinitions }
        override fun createdAt(createdAt: Instant): FluentBuilder = apply { this.createdAt = createdAt }
        override fun jobId(jobId: String): FluentBuilder = apply { this.jobId = jobId }
        override fun jobStatus(jobStatus: JobStatus): FluentBuilder = apply { this.jobStatus = jobStatus }
        override fun jobType(jobType: JobType): FluentBuilder = apply { this.jobType = jobType }
        override fun lastRunErrorStatus(lastRunErrorStatus: LastRunErrorStatus): FluentBuilder = apply { this.lastRunErrorStatus = lastRunErrorStatus }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun userPausedDetails(userPausedDetails: UserPausedDetails): FluentBuilder = apply { this.userPausedDetails = userPausedDetails }
    }
}
