// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides statistical data and other information about an S3 bucket that Amazon Macie monitors and analyzes.
 */
class MatchingBucket private constructor(builder: BuilderImpl) {
    /**
     * The unique identifier for the Amazon Web Services account that owns the bucket.
     */
    val accountId: String? = builder.accountId
    /**
     * The name of the bucket.
     */
    val bucketName: String? = builder.bucketName
    /**
     * The total number of objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format.
     */
    val classifiableObjectCount: Long? = builder.classifiableObjectCount
    /**
     * The total storage size, in bytes, of the objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format. If versioning is enabled for the bucket, Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn't reflect the storage size of all versions of each applicable object in the bucket.
     */
    val classifiableSizeInBytes: Long? = builder.classifiableSizeInBytes
    /**
     * Specifies whether any one-time or recurring classification jobs are configured to analyze objects in the bucket, and, if so, the details of the job that ran most recently.
     */
    val jobDetails: JobDetails? = builder.jobDetails
    /**
     * The total number of objects in the bucket.
     */
    val objectCount: Long? = builder.objectCount
    /**
     * The total number of objects that are in the bucket, grouped by server-side encryption type. This includes a grouping that reports the total number of objects that aren't encrypted or use client-side encryption.
     */
    val objectCountByEncryptionType: ObjectCountByEncryptionType? = builder.objectCountByEncryptionType
    /**
     * The total storage size, in bytes, of the bucket. If versioning is enabled for the bucket, Amazon Macie calculates this value based on the size of the latest version of each object in the bucket. This value doesn't reflect the storage size of all versions of each object in the bucket.
     */
    val sizeInBytes: Long? = builder.sizeInBytes
    /**
     * The total storage size, in bytes, of the objects that are compressed (.gz, .gzip, .zip) files in the bucket. If versioning is enabled for the bucket, Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn't reflect the storage size of all versions of each applicable object in the bucket.
     */
    val sizeInBytesCompressed: Long? = builder.sizeInBytesCompressed
    /**
     * The total number of objects that Amazon Macie can't analyze in the bucket. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.
     */
    val unclassifiableObjectCount: ObjectLevelStatistics? = builder.unclassifiableObjectCount
    /**
     * The total storage size, in bytes, of the objects that Amazon Macie can't analyze in the bucket. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.
     */
    val unclassifiableObjectSizeInBytes: ObjectLevelStatistics? = builder.unclassifiableObjectSizeInBytes

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): MatchingBucket = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("MatchingBucket(")
        append("accountId=$accountId,")
        append("bucketName=$bucketName,")
        append("classifiableObjectCount=$classifiableObjectCount,")
        append("classifiableSizeInBytes=$classifiableSizeInBytes,")
        append("jobDetails=$jobDetails,")
        append("objectCount=$objectCount,")
        append("objectCountByEncryptionType=$objectCountByEncryptionType,")
        append("sizeInBytes=$sizeInBytes,")
        append("sizeInBytesCompressed=$sizeInBytesCompressed,")
        append("unclassifiableObjectCount=$unclassifiableObjectCount,")
        append("unclassifiableObjectSizeInBytes=$unclassifiableObjectSizeInBytes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (bucketName?.hashCode() ?: 0)
        result = 31 * result + (classifiableObjectCount?.hashCode() ?: 0)
        result = 31 * result + (classifiableSizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (jobDetails?.hashCode() ?: 0)
        result = 31 * result + (objectCount?.hashCode() ?: 0)
        result = 31 * result + (objectCountByEncryptionType?.hashCode() ?: 0)
        result = 31 * result + (sizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (sizeInBytesCompressed?.hashCode() ?: 0)
        result = 31 * result + (unclassifiableObjectCount?.hashCode() ?: 0)
        result = 31 * result + (unclassifiableObjectSizeInBytes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as MatchingBucket

        if (accountId != other.accountId) return false
        if (bucketName != other.bucketName) return false
        if (classifiableObjectCount != other.classifiableObjectCount) return false
        if (classifiableSizeInBytes != other.classifiableSizeInBytes) return false
        if (jobDetails != other.jobDetails) return false
        if (objectCount != other.objectCount) return false
        if (objectCountByEncryptionType != other.objectCountByEncryptionType) return false
        if (sizeInBytes != other.sizeInBytes) return false
        if (sizeInBytesCompressed != other.sizeInBytesCompressed) return false
        if (unclassifiableObjectCount != other.unclassifiableObjectCount) return false
        if (unclassifiableObjectSizeInBytes != other.unclassifiableObjectSizeInBytes) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): MatchingBucket = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): MatchingBucket
        /**
         * The unique identifier for the Amazon Web Services account that owns the bucket.
         */
        fun accountId(accountId: String): FluentBuilder
        /**
         * The name of the bucket.
         */
        fun bucketName(bucketName: String): FluentBuilder
        /**
         * The total number of objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format.
         */
        fun classifiableObjectCount(classifiableObjectCount: Long): FluentBuilder
        /**
         * The total storage size, in bytes, of the objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format. If versioning is enabled for the bucket, Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn't reflect the storage size of all versions of each applicable object in the bucket.
         */
        fun classifiableSizeInBytes(classifiableSizeInBytes: Long): FluentBuilder
        /**
         * Specifies whether any one-time or recurring classification jobs are configured to analyze objects in the bucket, and, if so, the details of the job that ran most recently.
         */
        fun jobDetails(jobDetails: JobDetails): FluentBuilder
        /**
         * The total number of objects in the bucket.
         */
        fun objectCount(objectCount: Long): FluentBuilder
        /**
         * The total number of objects that are in the bucket, grouped by server-side encryption type. This includes a grouping that reports the total number of objects that aren't encrypted or use client-side encryption.
         */
        fun objectCountByEncryptionType(objectCountByEncryptionType: ObjectCountByEncryptionType): FluentBuilder
        /**
         * The total storage size, in bytes, of the bucket. If versioning is enabled for the bucket, Amazon Macie calculates this value based on the size of the latest version of each object in the bucket. This value doesn't reflect the storage size of all versions of each object in the bucket.
         */
        fun sizeInBytes(sizeInBytes: Long): FluentBuilder
        /**
         * The total storage size, in bytes, of the objects that are compressed (.gz, .gzip, .zip) files in the bucket. If versioning is enabled for the bucket, Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn't reflect the storage size of all versions of each applicable object in the bucket.
         */
        fun sizeInBytesCompressed(sizeInBytesCompressed: Long): FluentBuilder
        /**
         * The total number of objects that Amazon Macie can't analyze in the bucket. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.
         */
        fun unclassifiableObjectCount(unclassifiableObjectCount: ObjectLevelStatistics): FluentBuilder
        /**
         * The total storage size, in bytes, of the objects that Amazon Macie can't analyze in the bucket. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.
         */
        fun unclassifiableObjectSizeInBytes(unclassifiableObjectSizeInBytes: ObjectLevelStatistics): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The unique identifier for the Amazon Web Services account that owns the bucket.
         */
        var accountId: String?
        /**
         * The name of the bucket.
         */
        var bucketName: String?
        /**
         * The total number of objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format.
         */
        var classifiableObjectCount: Long?
        /**
         * The total storage size, in bytes, of the objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format. If versioning is enabled for the bucket, Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn't reflect the storage size of all versions of each applicable object in the bucket.
         */
        var classifiableSizeInBytes: Long?
        /**
         * Specifies whether any one-time or recurring classification jobs are configured to analyze objects in the bucket, and, if so, the details of the job that ran most recently.
         */
        var jobDetails: JobDetails?
        /**
         * The total number of objects in the bucket.
         */
        var objectCount: Long?
        /**
         * The total number of objects that are in the bucket, grouped by server-side encryption type. This includes a grouping that reports the total number of objects that aren't encrypted or use client-side encryption.
         */
        var objectCountByEncryptionType: ObjectCountByEncryptionType?
        /**
         * The total storage size, in bytes, of the bucket. If versioning is enabled for the bucket, Amazon Macie calculates this value based on the size of the latest version of each object in the bucket. This value doesn't reflect the storage size of all versions of each object in the bucket.
         */
        var sizeInBytes: Long?
        /**
         * The total storage size, in bytes, of the objects that are compressed (.gz, .gzip, .zip) files in the bucket. If versioning is enabled for the bucket, Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn't reflect the storage size of all versions of each applicable object in the bucket.
         */
        var sizeInBytesCompressed: Long?
        /**
         * The total number of objects that Amazon Macie can't analyze in the bucket. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.
         */
        var unclassifiableObjectCount: ObjectLevelStatistics?
        /**
         * The total storage size, in bytes, of the objects that Amazon Macie can't analyze in the bucket. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.
         */
        var unclassifiableObjectSizeInBytes: ObjectLevelStatistics?

        fun build(): MatchingBucket
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.JobDetails] inside the given [block]
         */
        fun jobDetails(block: JobDetails.DslBuilder.() -> kotlin.Unit) {
            this.jobDetails = JobDetails.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.ObjectCountByEncryptionType] inside the given [block]
         */
        fun objectCountByEncryptionType(block: ObjectCountByEncryptionType.DslBuilder.() -> kotlin.Unit) {
            this.objectCountByEncryptionType = ObjectCountByEncryptionType.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics] inside the given [block]
         */
        fun unclassifiableObjectCount(block: ObjectLevelStatistics.DslBuilder.() -> kotlin.Unit) {
            this.unclassifiableObjectCount = ObjectLevelStatistics.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics] inside the given [block]
         */
        fun unclassifiableObjectSizeInBytes(block: ObjectLevelStatistics.DslBuilder.() -> kotlin.Unit) {
            this.unclassifiableObjectSizeInBytes = ObjectLevelStatistics.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accountId: String? = null
        override var bucketName: String? = null
        override var classifiableObjectCount: Long? = null
        override var classifiableSizeInBytes: Long? = null
        override var jobDetails: JobDetails? = null
        override var objectCount: Long? = null
        override var objectCountByEncryptionType: ObjectCountByEncryptionType? = null
        override var sizeInBytes: Long? = null
        override var sizeInBytesCompressed: Long? = null
        override var unclassifiableObjectCount: ObjectLevelStatistics? = null
        override var unclassifiableObjectSizeInBytes: ObjectLevelStatistics? = null

        constructor(x: MatchingBucket) : this() {
            this.accountId = x.accountId
            this.bucketName = x.bucketName
            this.classifiableObjectCount = x.classifiableObjectCount
            this.classifiableSizeInBytes = x.classifiableSizeInBytes
            this.jobDetails = x.jobDetails
            this.objectCount = x.objectCount
            this.objectCountByEncryptionType = x.objectCountByEncryptionType
            this.sizeInBytes = x.sizeInBytes
            this.sizeInBytesCompressed = x.sizeInBytesCompressed
            this.unclassifiableObjectCount = x.unclassifiableObjectCount
            this.unclassifiableObjectSizeInBytes = x.unclassifiableObjectSizeInBytes
        }

        override fun build(): MatchingBucket = MatchingBucket(this)
        override fun accountId(accountId: String): FluentBuilder = apply { this.accountId = accountId }
        override fun bucketName(bucketName: String): FluentBuilder = apply { this.bucketName = bucketName }
        override fun classifiableObjectCount(classifiableObjectCount: Long): FluentBuilder = apply { this.classifiableObjectCount = classifiableObjectCount }
        override fun classifiableSizeInBytes(classifiableSizeInBytes: Long): FluentBuilder = apply { this.classifiableSizeInBytes = classifiableSizeInBytes }
        override fun jobDetails(jobDetails: JobDetails): FluentBuilder = apply { this.jobDetails = jobDetails }
        override fun objectCount(objectCount: Long): FluentBuilder = apply { this.objectCount = objectCount }
        override fun objectCountByEncryptionType(objectCountByEncryptionType: ObjectCountByEncryptionType): FluentBuilder = apply { this.objectCountByEncryptionType = objectCountByEncryptionType }
        override fun sizeInBytes(sizeInBytes: Long): FluentBuilder = apply { this.sizeInBytes = sizeInBytes }
        override fun sizeInBytesCompressed(sizeInBytesCompressed: Long): FluentBuilder = apply { this.sizeInBytesCompressed = sizeInBytesCompressed }
        override fun unclassifiableObjectCount(unclassifiableObjectCount: ObjectLevelStatistics): FluentBuilder = apply { this.unclassifiableObjectCount = unclassifiableObjectCount }
        override fun unclassifiableObjectSizeInBytes(unclassifiableObjectSizeInBytes: ObjectLevelStatistics): FluentBuilder = apply { this.unclassifiableObjectSizeInBytes = unclassifiableObjectSizeInBytes }
    }
}
