// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about the number of objects that are in an S3 bucket and use certain types of server-side encryption, use client-side encryption, or aren't encrypted.
 */
class ObjectCountByEncryptionType private constructor(builder: BuilderImpl) {
    /**
     * The total number of objects that are encrypted with a customer-managed key. The objects use customer-provided server-side encryption (SSE-C).
     */
    val customerManaged: Long? = builder.customerManaged
    /**
     * The total number of objects that are encrypted with an Key Management Service (KMS) customer master key (CMK). The objects use Amazon Web Services managed KMS encryption (AWS-KMS) or customer managed KMS encryption (SSE-KMS).
     */
    val kmsManaged: Long? = builder.kmsManaged
    /**
     * The total number of objects that are encrypted with an Amazon S3 managed key. The objects use Amazon S3 managed encryption (SSE-S3).
     */
    val s3Managed: Long? = builder.s3Managed
    /**
     * The total number of objects that aren't encrypted or use client-side encryption.
     */
    val unencrypted: Long? = builder.unencrypted
    /**
     * The total number of objects that Amazon Macie doesn't have current encryption metadata for. Macie can't provide current data about the encryption settings for these objects.
     */
    val unknown: Long? = builder.unknown

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ObjectCountByEncryptionType = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ObjectCountByEncryptionType(")
        append("customerManaged=$customerManaged,")
        append("kmsManaged=$kmsManaged,")
        append("s3Managed=$s3Managed,")
        append("unencrypted=$unencrypted,")
        append("unknown=$unknown)")
    }

    override fun hashCode(): kotlin.Int {
        var result = customerManaged?.hashCode() ?: 0
        result = 31 * result + (kmsManaged?.hashCode() ?: 0)
        result = 31 * result + (s3Managed?.hashCode() ?: 0)
        result = 31 * result + (unencrypted?.hashCode() ?: 0)
        result = 31 * result + (unknown?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ObjectCountByEncryptionType

        if (customerManaged != other.customerManaged) return false
        if (kmsManaged != other.kmsManaged) return false
        if (s3Managed != other.s3Managed) return false
        if (unencrypted != other.unencrypted) return false
        if (unknown != other.unknown) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ObjectCountByEncryptionType = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ObjectCountByEncryptionType
        /**
         * The total number of objects that are encrypted with a customer-managed key. The objects use customer-provided server-side encryption (SSE-C).
         */
        fun customerManaged(customerManaged: Long): FluentBuilder
        /**
         * The total number of objects that are encrypted with an Key Management Service (KMS) customer master key (CMK). The objects use Amazon Web Services managed KMS encryption (AWS-KMS) or customer managed KMS encryption (SSE-KMS).
         */
        fun kmsManaged(kmsManaged: Long): FluentBuilder
        /**
         * The total number of objects that are encrypted with an Amazon S3 managed key. The objects use Amazon S3 managed encryption (SSE-S3).
         */
        fun s3Managed(s3Managed: Long): FluentBuilder
        /**
         * The total number of objects that aren't encrypted or use client-side encryption.
         */
        fun unencrypted(unencrypted: Long): FluentBuilder
        /**
         * The total number of objects that Amazon Macie doesn't have current encryption metadata for. Macie can't provide current data about the encryption settings for these objects.
         */
        fun unknown(unknown: Long): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The total number of objects that are encrypted with a customer-managed key. The objects use customer-provided server-side encryption (SSE-C).
         */
        var customerManaged: Long?
        /**
         * The total number of objects that are encrypted with an Key Management Service (KMS) customer master key (CMK). The objects use Amazon Web Services managed KMS encryption (AWS-KMS) or customer managed KMS encryption (SSE-KMS).
         */
        var kmsManaged: Long?
        /**
         * The total number of objects that are encrypted with an Amazon S3 managed key. The objects use Amazon S3 managed encryption (SSE-S3).
         */
        var s3Managed: Long?
        /**
         * The total number of objects that aren't encrypted or use client-side encryption.
         */
        var unencrypted: Long?
        /**
         * The total number of objects that Amazon Macie doesn't have current encryption metadata for. Macie can't provide current data about the encryption settings for these objects.
         */
        var unknown: Long?

        fun build(): ObjectCountByEncryptionType
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var customerManaged: Long? = null
        override var kmsManaged: Long? = null
        override var s3Managed: Long? = null
        override var unencrypted: Long? = null
        override var unknown: Long? = null

        constructor(x: ObjectCountByEncryptionType) : this() {
            this.customerManaged = x.customerManaged
            this.kmsManaged = x.kmsManaged
            this.s3Managed = x.s3Managed
            this.unencrypted = x.unencrypted
            this.unknown = x.unknown
        }

        override fun build(): ObjectCountByEncryptionType = ObjectCountByEncryptionType(this)
        override fun customerManaged(customerManaged: Long): FluentBuilder = apply { this.customerManaged = customerManaged }
        override fun kmsManaged(kmsManaged: Long): FluentBuilder = apply { this.kmsManaged = kmsManaged }
        override fun s3Managed(s3Managed: Long): FluentBuilder = apply { this.s3Managed = s3Managed }
        override fun unencrypted(unencrypted: Long): FluentBuilder = apply { this.unencrypted = unencrypted }
        override fun unknown(unknown: Long): FluentBuilder = apply { this.unknown = unknown }
    }
}
