// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about the total storage size (in bytes) or number of objects that Amazon Macie can't analyze in one or more S3 buckets. In a BucketMetadata or MatchingBucket object, this data is for a specific bucket. In a GetBucketStatisticsResponse object, this data is aggregated for all the buckets in the query results. If versioning is enabled for a bucket, total storage size values are based on the size of the latest version of each applicable object in the bucket.
 */
class ObjectLevelStatistics private constructor(builder: BuilderImpl) {
    /**
     * The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the objects don't have a file name extension for a supported file or storage format.
     */
    val fileType: Long? = builder.fileType
    /**
     * The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the objects use an unsupported storage class.
     */
    val storageClass: Long? = builder.storageClass
    /**
     * The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the objects use an unsupported storage class or don't have a file name extension for a supported file or storage format.
     */
    val total: Long? = builder.total

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ObjectLevelStatistics = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ObjectLevelStatistics(")
        append("fileType=$fileType,")
        append("storageClass=$storageClass,")
        append("total=$total)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fileType?.hashCode() ?: 0
        result = 31 * result + (storageClass?.hashCode() ?: 0)
        result = 31 * result + (total?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ObjectLevelStatistics

        if (fileType != other.fileType) return false
        if (storageClass != other.storageClass) return false
        if (total != other.total) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ObjectLevelStatistics = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ObjectLevelStatistics
        /**
         * The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the objects don't have a file name extension for a supported file or storage format.
         */
        fun fileType(fileType: Long): FluentBuilder
        /**
         * The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the objects use an unsupported storage class.
         */
        fun storageClass(storageClass: Long): FluentBuilder
        /**
         * The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the objects use an unsupported storage class or don't have a file name extension for a supported file or storage format.
         */
        fun total(total: Long): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the objects don't have a file name extension for a supported file or storage format.
         */
        var fileType: Long?
        /**
         * The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the objects use an unsupported storage class.
         */
        var storageClass: Long?
        /**
         * The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the objects use an unsupported storage class or don't have a file name extension for a supported file or storage format.
         */
        var total: Long?

        fun build(): ObjectLevelStatistics
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var fileType: Long? = null
        override var storageClass: Long? = null
        override var total: Long? = null

        constructor(x: ObjectLevelStatistics) : this() {
            this.fileType = x.fileType
            this.storageClass = x.storageClass
            this.total = x.total
        }

        override fun build(): ObjectLevelStatistics = ObjectLevelStatistics(this)
        override fun fileType(fileType: Long): FluentBuilder = apply { this.fileType = fileType }
        override fun storageClass(storageClass: Long): FluentBuilder = apply { this.storageClass = storageClass }
        override fun total(total: Long): FluentBuilder = apply { this.total = total }
    }
}
