// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Specifies the location of an occurrence of sensitive data in an Apache Avro object container, Apache Parquet file, JSON file, or JSON Lines file.
 */
class Record private constructor(builder: BuilderImpl) {
    /**
     * The path, as a JSONPath expression, to the sensitive data. For an Avro object container or Parquet file, this is the path to the field in the record (recordIndex) that contains the data. For a JSON or JSON Lines file, this is the path to the field or array that contains the data. If the data is a value in an array, the path also indicates which value contains the data. If Amazon Macie detects sensitive data in the name of any element in the path, Macie omits this field. If the name of an element exceeds 20 characters, Macie truncates the name by removing characters from the beginning of the name. If the resulting full path exceeds 250 characters, Macie also truncates the path, starting with the first element in the path, until the path contains 250 or fewer characters.
     */
    val jsonPath: String? = builder.jsonPath
    /**
     * For an Avro object container or Parquet file, the record index, starting from 0, for the record that contains the sensitive data. For a JSON Lines file, the line index, starting from 0, for the line that contains the sensitive data. This value is always 0 for JSON files.
     */
    val recordIndex: Long? = builder.recordIndex

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Record = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Record(")
        append("jsonPath=$jsonPath,")
        append("recordIndex=$recordIndex)")
    }

    override fun hashCode(): kotlin.Int {
        var result = jsonPath?.hashCode() ?: 0
        result = 31 * result + (recordIndex?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Record

        if (jsonPath != other.jsonPath) return false
        if (recordIndex != other.recordIndex) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Record = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Record
        /**
         * The path, as a JSONPath expression, to the sensitive data. For an Avro object container or Parquet file, this is the path to the field in the record (recordIndex) that contains the data. For a JSON or JSON Lines file, this is the path to the field or array that contains the data. If the data is a value in an array, the path also indicates which value contains the data. If Amazon Macie detects sensitive data in the name of any element in the path, Macie omits this field. If the name of an element exceeds 20 characters, Macie truncates the name by removing characters from the beginning of the name. If the resulting full path exceeds 250 characters, Macie also truncates the path, starting with the first element in the path, until the path contains 250 or fewer characters.
         */
        fun jsonPath(jsonPath: String): FluentBuilder
        /**
         * For an Avro object container or Parquet file, the record index, starting from 0, for the record that contains the sensitive data. For a JSON Lines file, the line index, starting from 0, for the line that contains the sensitive data. This value is always 0 for JSON files.
         */
        fun recordIndex(recordIndex: Long): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The path, as a JSONPath expression, to the sensitive data. For an Avro object container or Parquet file, this is the path to the field in the record (recordIndex) that contains the data. For a JSON or JSON Lines file, this is the path to the field or array that contains the data. If the data is a value in an array, the path also indicates which value contains the data. If Amazon Macie detects sensitive data in the name of any element in the path, Macie omits this field. If the name of an element exceeds 20 characters, Macie truncates the name by removing characters from the beginning of the name. If the resulting full path exceeds 250 characters, Macie also truncates the path, starting with the first element in the path, until the path contains 250 or fewer characters.
         */
        var jsonPath: String?
        /**
         * For an Avro object container or Parquet file, the record index, starting from 0, for the record that contains the sensitive data. For a JSON Lines file, the line index, starting from 0, for the line that contains the sensitive data. This value is always 0 for JSON files.
         */
        var recordIndex: Long?

        fun build(): Record
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var jsonPath: String? = null
        override var recordIndex: Long? = null

        constructor(x: Record) : this() {
            this.jsonPath = x.jsonPath
            this.recordIndex = x.recordIndex
        }

        override fun build(): Record = Record(this)
        override fun jsonPath(jsonPath: String): FluentBuilder = apply { this.jsonPath = jsonPath }
        override fun recordIndex(recordIndex: Long): FluentBuilder = apply { this.recordIndex = recordIndex }
    }
}
