// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about settings that define whether one or more objects in an S3 bucket are replicated to S3 buckets for other Amazon Web Services accounts and, if so, which accounts.
 */
class ReplicationDetails private constructor(builder: BuilderImpl) {
    /**
     * Specifies whether the bucket is configured to replicate one or more objects to any destination.
     */
    val replicated: Boolean? = builder.replicated
    /**
     * Specifies whether the bucket is configured to replicate one or more objects to an Amazon Web Services account that isn't part of the same Amazon Macie organization.
     */
    val replicatedExternally: Boolean? = builder.replicatedExternally
    /**
     * An array of Amazon Web Services account IDs, one for each Amazon Web Services account that the bucket is configured to replicate one or more objects to.
     */
    val replicationAccounts: List<String>? = builder.replicationAccounts

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ReplicationDetails = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ReplicationDetails(")
        append("replicated=$replicated,")
        append("replicatedExternally=$replicatedExternally,")
        append("replicationAccounts=$replicationAccounts)")
    }

    override fun hashCode(): kotlin.Int {
        var result = replicated?.hashCode() ?: 0
        result = 31 * result + (replicatedExternally?.hashCode() ?: 0)
        result = 31 * result + (replicationAccounts?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ReplicationDetails

        if (replicated != other.replicated) return false
        if (replicatedExternally != other.replicatedExternally) return false
        if (replicationAccounts != other.replicationAccounts) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ReplicationDetails = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ReplicationDetails
        /**
         * Specifies whether the bucket is configured to replicate one or more objects to any destination.
         */
        fun replicated(replicated: Boolean): FluentBuilder
        /**
         * Specifies whether the bucket is configured to replicate one or more objects to an Amazon Web Services account that isn't part of the same Amazon Macie organization.
         */
        fun replicatedExternally(replicatedExternally: Boolean): FluentBuilder
        /**
         * An array of Amazon Web Services account IDs, one for each Amazon Web Services account that the bucket is configured to replicate one or more objects to.
         */
        fun replicationAccounts(replicationAccounts: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specifies whether the bucket is configured to replicate one or more objects to any destination.
         */
        var replicated: Boolean?
        /**
         * Specifies whether the bucket is configured to replicate one or more objects to an Amazon Web Services account that isn't part of the same Amazon Macie organization.
         */
        var replicatedExternally: Boolean?
        /**
         * An array of Amazon Web Services account IDs, one for each Amazon Web Services account that the bucket is configured to replicate one or more objects to.
         */
        var replicationAccounts: List<String>?

        fun build(): ReplicationDetails
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var replicated: Boolean? = null
        override var replicatedExternally: Boolean? = null
        override var replicationAccounts: List<String>? = null

        constructor(x: ReplicationDetails) : this() {
            this.replicated = x.replicated
            this.replicatedExternally = x.replicatedExternally
            this.replicationAccounts = x.replicationAccounts
        }

        override fun build(): ReplicationDetails = ReplicationDetails(this)
        override fun replicated(replicated: Boolean): FluentBuilder = apply { this.replicated = replicated }
        override fun replicatedExternally(replicatedExternally: Boolean): FluentBuilder = apply { this.replicatedExternally = replicatedExternally }
        override fun replicationAccounts(replicationAccounts: List<String>): FluentBuilder = apply { this.replicationAccounts = replicationAccounts }
    }
}
