// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about the resources that a finding applies to.
 */
class ResourcesAffected private constructor(builder: BuilderImpl) {
    /**
     * The details of the S3 bucket that the finding applies to.
     */
    val s3Bucket: S3Bucket? = builder.s3Bucket
    /**
     * The details of the S3 object that the finding applies to.
     */
    val s3Object: S3Object? = builder.s3Object

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ResourcesAffected = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ResourcesAffected(")
        append("s3Bucket=$s3Bucket,")
        append("s3Object=$s3Object)")
    }

    override fun hashCode(): kotlin.Int {
        var result = s3Bucket?.hashCode() ?: 0
        result = 31 * result + (s3Object?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ResourcesAffected

        if (s3Bucket != other.s3Bucket) return false
        if (s3Object != other.s3Object) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ResourcesAffected = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ResourcesAffected
        /**
         * The details of the S3 bucket that the finding applies to.
         */
        fun s3Bucket(s3Bucket: S3Bucket): FluentBuilder
        /**
         * The details of the S3 object that the finding applies to.
         */
        fun s3Object(s3Object: S3Object): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The details of the S3 bucket that the finding applies to.
         */
        var s3Bucket: S3Bucket?
        /**
         * The details of the S3 object that the finding applies to.
         */
        var s3Object: S3Object?

        fun build(): ResourcesAffected
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.S3Bucket] inside the given [block]
         */
        fun s3Bucket(block: S3Bucket.DslBuilder.() -> kotlin.Unit) {
            this.s3Bucket = S3Bucket.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.S3Object] inside the given [block]
         */
        fun s3Object(block: S3Object.DslBuilder.() -> kotlin.Unit) {
            this.s3Object = S3Object.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var s3Bucket: S3Bucket? = null
        override var s3Object: S3Object? = null

        constructor(x: ResourcesAffected) : this() {
            this.s3Bucket = x.s3Bucket
            this.s3Object = x.s3Object
        }

        override fun build(): ResourcesAffected = ResourcesAffected(this)
        override fun s3Bucket(s3Bucket: S3Bucket): FluentBuilder = apply { this.s3Bucket = s3Bucket }
        override fun s3Object(s3Object: S3Object): FluentBuilder = apply { this.s3Object = s3Object }
    }
}
