// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information about the S3 bucket that a finding applies to.
 */
class S3Bucket private constructor(builder: BuilderImpl) {
    /**
     * Specifies whether the bucket policy for the bucket requires server-side encryption of objects when objects are uploaded to the bucket. Possible values are: FALSE - The bucket policy requires server-side encryption of new objects. PutObject requests must include the x-amz-server-side-encryption header and the value for that header must be AES256 or aws:kms. TRUE - The bucket doesn't have a bucket policy or it has a bucket policy that doesn't require server-side encryption of new objects. If a bucket policy exists, it doesn't require PutObject requests to include the x-amz-server-side-encryption header and it doesn't require the value for that header to be AES256 or aws:kms. UNKNOWN - Amazon Macie can't determine whether the bucket policy requires server-side encryption of objects.
     */
    val allowsUnencryptedObjectUploads: AllowsUnencryptedObjectUploads? = builder.allowsUnencryptedObjectUploads
    /**
     * The Amazon Resource Name (ARN) of the bucket.
     */
    val arn: String? = builder.arn
    /**
     * The date and time, in UTC and extended ISO 8601 format, when the bucket was created.
     */
    val createdAt: Instant? = builder.createdAt
    /**
     * The type of server-side encryption that's used by default to encrypt objects in the bucket.
     */
    val defaultServerSideEncryption: ServerSideEncryption? = builder.defaultServerSideEncryption
    /**
     * The name of the bucket.
     */
    val name: String? = builder.name
    /**
     * The display name and Amazon Web Services account ID for the user who owns the bucket.
     */
    val owner: S3BucketOwner? = builder.owner
    /**
     * The permissions settings that determine whether the bucket is publicly accessible.
     */
    val publicAccess: BucketPublicAccess? = builder.publicAccess
    /**
     * The tags that are associated with the bucket.
     */
    val tags: List<KeyValuePair>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): S3Bucket = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("S3Bucket(")
        append("allowsUnencryptedObjectUploads=$allowsUnencryptedObjectUploads,")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("defaultServerSideEncryption=$defaultServerSideEncryption,")
        append("name=$name,")
        append("owner=$owner,")
        append("publicAccess=$publicAccess,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowsUnencryptedObjectUploads?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (defaultServerSideEncryption?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (publicAccess?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as S3Bucket

        if (allowsUnencryptedObjectUploads != other.allowsUnencryptedObjectUploads) return false
        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (defaultServerSideEncryption != other.defaultServerSideEncryption) return false
        if (name != other.name) return false
        if (owner != other.owner) return false
        if (publicAccess != other.publicAccess) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): S3Bucket = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): S3Bucket
        /**
         * Specifies whether the bucket policy for the bucket requires server-side encryption of objects when objects are uploaded to the bucket. Possible values are: FALSE - The bucket policy requires server-side encryption of new objects. PutObject requests must include the x-amz-server-side-encryption header and the value for that header must be AES256 or aws:kms. TRUE - The bucket doesn't have a bucket policy or it has a bucket policy that doesn't require server-side encryption of new objects. If a bucket policy exists, it doesn't require PutObject requests to include the x-amz-server-side-encryption header and it doesn't require the value for that header to be AES256 or aws:kms. UNKNOWN - Amazon Macie can't determine whether the bucket policy requires server-side encryption of objects.
         */
        fun allowsUnencryptedObjectUploads(allowsUnencryptedObjectUploads: AllowsUnencryptedObjectUploads): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the bucket.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the bucket was created.
         */
        fun createdAt(createdAt: Instant): FluentBuilder
        /**
         * The type of server-side encryption that's used by default to encrypt objects in the bucket.
         */
        fun defaultServerSideEncryption(defaultServerSideEncryption: ServerSideEncryption): FluentBuilder
        /**
         * The name of the bucket.
         */
        fun name(name: String): FluentBuilder
        /**
         * The display name and Amazon Web Services account ID for the user who owns the bucket.
         */
        fun owner(owner: S3BucketOwner): FluentBuilder
        /**
         * The permissions settings that determine whether the bucket is publicly accessible.
         */
        fun publicAccess(publicAccess: BucketPublicAccess): FluentBuilder
        /**
         * The tags that are associated with the bucket.
         */
        fun tags(tags: List<KeyValuePair>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specifies whether the bucket policy for the bucket requires server-side encryption of objects when objects are uploaded to the bucket. Possible values are: FALSE - The bucket policy requires server-side encryption of new objects. PutObject requests must include the x-amz-server-side-encryption header and the value for that header must be AES256 or aws:kms. TRUE - The bucket doesn't have a bucket policy or it has a bucket policy that doesn't require server-side encryption of new objects. If a bucket policy exists, it doesn't require PutObject requests to include the x-amz-server-side-encryption header and it doesn't require the value for that header to be AES256 or aws:kms. UNKNOWN - Amazon Macie can't determine whether the bucket policy requires server-side encryption of objects.
         */
        var allowsUnencryptedObjectUploads: AllowsUnencryptedObjectUploads?
        /**
         * The Amazon Resource Name (ARN) of the bucket.
         */
        var arn: String?
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the bucket was created.
         */
        var createdAt: Instant?
        /**
         * The type of server-side encryption that's used by default to encrypt objects in the bucket.
         */
        var defaultServerSideEncryption: ServerSideEncryption?
        /**
         * The name of the bucket.
         */
        var name: String?
        /**
         * The display name and Amazon Web Services account ID for the user who owns the bucket.
         */
        var owner: S3BucketOwner?
        /**
         * The permissions settings that determine whether the bucket is publicly accessible.
         */
        var publicAccess: BucketPublicAccess?
        /**
         * The tags that are associated with the bucket.
         */
        var tags: List<KeyValuePair>?

        fun build(): S3Bucket
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.ServerSideEncryption] inside the given [block]
         */
        fun defaultServerSideEncryption(block: ServerSideEncryption.DslBuilder.() -> kotlin.Unit) {
            this.defaultServerSideEncryption = ServerSideEncryption.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.S3BucketOwner] inside the given [block]
         */
        fun owner(block: S3BucketOwner.DslBuilder.() -> kotlin.Unit) {
            this.owner = S3BucketOwner.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.BucketPublicAccess] inside the given [block]
         */
        fun publicAccess(block: BucketPublicAccess.DslBuilder.() -> kotlin.Unit) {
            this.publicAccess = BucketPublicAccess.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var allowsUnencryptedObjectUploads: AllowsUnencryptedObjectUploads? = null
        override var arn: String? = null
        override var createdAt: Instant? = null
        override var defaultServerSideEncryption: ServerSideEncryption? = null
        override var name: String? = null
        override var owner: S3BucketOwner? = null
        override var publicAccess: BucketPublicAccess? = null
        override var tags: List<KeyValuePair>? = null

        constructor(x: S3Bucket) : this() {
            this.allowsUnencryptedObjectUploads = x.allowsUnencryptedObjectUploads
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.defaultServerSideEncryption = x.defaultServerSideEncryption
            this.name = x.name
            this.owner = x.owner
            this.publicAccess = x.publicAccess
            this.tags = x.tags
        }

        override fun build(): S3Bucket = S3Bucket(this)
        override fun allowsUnencryptedObjectUploads(allowsUnencryptedObjectUploads: AllowsUnencryptedObjectUploads): FluentBuilder = apply { this.allowsUnencryptedObjectUploads = allowsUnencryptedObjectUploads }
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun createdAt(createdAt: Instant): FluentBuilder = apply { this.createdAt = createdAt }
        override fun defaultServerSideEncryption(defaultServerSideEncryption: ServerSideEncryption): FluentBuilder = apply { this.defaultServerSideEncryption = defaultServerSideEncryption }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun owner(owner: S3BucketOwner): FluentBuilder = apply { this.owner = owner }
        override fun publicAccess(publicAccess: BucketPublicAccess): FluentBuilder = apply { this.publicAccess = publicAccess }
        override fun tags(tags: List<KeyValuePair>): FluentBuilder = apply { this.tags = tags }
    }
}
