// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Specifies an S3 bucket to store data classification results in, and the encryption settings to use when storing results in that bucket.
 */
class S3Destination private constructor(builder: BuilderImpl) {
    /**
     * The name of the bucket.
     */
    val bucketName: String? = builder.bucketName
    /**
     * The path prefix to use in the path to the location in the bucket. This prefix specifies where to store classification results in the bucket.
     */
    val keyPrefix: String? = builder.keyPrefix
    /**
     * The Amazon Resource Name (ARN) of the Key Management Service (KMS) customer master key (CMK) to use for encryption of the results. This must be the ARN of an existing CMK that's in the same Amazon Web Services Region as the bucket.
     */
    val kmsKeyArn: String? = builder.kmsKeyArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): S3Destination = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("S3Destination(")
        append("bucketName=$bucketName,")
        append("keyPrefix=$keyPrefix,")
        append("kmsKeyArn=$kmsKeyArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketName?.hashCode() ?: 0
        result = 31 * result + (keyPrefix?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as S3Destination

        if (bucketName != other.bucketName) return false
        if (keyPrefix != other.keyPrefix) return false
        if (kmsKeyArn != other.kmsKeyArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): S3Destination = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): S3Destination
        /**
         * The name of the bucket.
         */
        fun bucketName(bucketName: String): FluentBuilder
        /**
         * The path prefix to use in the path to the location in the bucket. This prefix specifies where to store classification results in the bucket.
         */
        fun keyPrefix(keyPrefix: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the Key Management Service (KMS) customer master key (CMK) to use for encryption of the results. This must be the ARN of an existing CMK that's in the same Amazon Web Services Region as the bucket.
         */
        fun kmsKeyArn(kmsKeyArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the bucket.
         */
        var bucketName: String?
        /**
         * The path prefix to use in the path to the location in the bucket. This prefix specifies where to store classification results in the bucket.
         */
        var keyPrefix: String?
        /**
         * The Amazon Resource Name (ARN) of the Key Management Service (KMS) customer master key (CMK) to use for encryption of the results. This must be the ARN of an existing CMK that's in the same Amazon Web Services Region as the bucket.
         */
        var kmsKeyArn: String?

        fun build(): S3Destination
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var bucketName: String? = null
        override var keyPrefix: String? = null
        override var kmsKeyArn: String? = null

        constructor(x: S3Destination) : this() {
            this.bucketName = x.bucketName
            this.keyPrefix = x.keyPrefix
            this.kmsKeyArn = x.kmsKeyArn
        }

        override fun build(): S3Destination = S3Destination(this)
        override fun bucketName(bucketName: String): FluentBuilder = apply { this.bucketName = bucketName }
        override fun keyPrefix(keyPrefix: String): FluentBuilder = apply { this.keyPrefix = keyPrefix }
        override fun kmsKeyArn(kmsKeyArn: String): FluentBuilder = apply { this.kmsKeyArn = kmsKeyArn }
    }
}
