// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Specifies which S3 buckets contain the objects that a classification job analyzes, and the scope of that analysis. The bucket specification can be static (bucketDefinitions) or dynamic (bucketCriteria). If it's static, the job analyzes objects in the same predefined set of buckets each time the job runs. If it's dynamic, the job analyzes objects in any buckets that match the specified criteria each time the job starts to run.
 */
class S3JobDefinition private constructor(builder: BuilderImpl) {
    /**
     * The property- and tag-based conditions that determine which S3 buckets to include or exclude from the analysis. Each time the job runs, the job uses these criteria to determine which buckets contain objects to analyze. A job's definition can contain a bucketCriteria object or a bucketDefinitions array, not both.
     */
    val bucketCriteria: S3BucketCriteriaForJob? = builder.bucketCriteria
    /**
     * An array of objects, one for each Amazon Web Services account that owns specific S3 buckets to analyze. Each object specifies the account ID for an account and one or more buckets to analyze for that account. A job's definition can contain a bucketDefinitions array or a bucketCriteria object, not both.
     */
    val bucketDefinitions: List<S3BucketDefinitionForJob>? = builder.bucketDefinitions
    /**
     * The property- and tag-based conditions that determine which S3 objects to include or exclude from the analysis. Each time the job runs, the job uses these criteria to determine which objects to analyze.
     */
    val scoping: Scoping? = builder.scoping

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): S3JobDefinition = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("S3JobDefinition(")
        append("bucketCriteria=$bucketCriteria,")
        append("bucketDefinitions=$bucketDefinitions,")
        append("scoping=$scoping)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketCriteria?.hashCode() ?: 0
        result = 31 * result + (bucketDefinitions?.hashCode() ?: 0)
        result = 31 * result + (scoping?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as S3JobDefinition

        if (bucketCriteria != other.bucketCriteria) return false
        if (bucketDefinitions != other.bucketDefinitions) return false
        if (scoping != other.scoping) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): S3JobDefinition = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): S3JobDefinition
        /**
         * The property- and tag-based conditions that determine which S3 buckets to include or exclude from the analysis. Each time the job runs, the job uses these criteria to determine which buckets contain objects to analyze. A job's definition can contain a bucketCriteria object or a bucketDefinitions array, not both.
         */
        fun bucketCriteria(bucketCriteria: S3BucketCriteriaForJob): FluentBuilder
        /**
         * An array of objects, one for each Amazon Web Services account that owns specific S3 buckets to analyze. Each object specifies the account ID for an account and one or more buckets to analyze for that account. A job's definition can contain a bucketDefinitions array or a bucketCriteria object, not both.
         */
        fun bucketDefinitions(bucketDefinitions: List<S3BucketDefinitionForJob>): FluentBuilder
        /**
         * The property- and tag-based conditions that determine which S3 objects to include or exclude from the analysis. Each time the job runs, the job uses these criteria to determine which objects to analyze.
         */
        fun scoping(scoping: Scoping): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The property- and tag-based conditions that determine which S3 buckets to include or exclude from the analysis. Each time the job runs, the job uses these criteria to determine which buckets contain objects to analyze. A job's definition can contain a bucketCriteria object or a bucketDefinitions array, not both.
         */
        var bucketCriteria: S3BucketCriteriaForJob?
        /**
         * An array of objects, one for each Amazon Web Services account that owns specific S3 buckets to analyze. Each object specifies the account ID for an account and one or more buckets to analyze for that account. A job's definition can contain a bucketDefinitions array or a bucketCriteria object, not both.
         */
        var bucketDefinitions: List<S3BucketDefinitionForJob>?
        /**
         * The property- and tag-based conditions that determine which S3 objects to include or exclude from the analysis. Each time the job runs, the job uses these criteria to determine which objects to analyze.
         */
        var scoping: Scoping?

        fun build(): S3JobDefinition
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.S3BucketCriteriaForJob] inside the given [block]
         */
        fun bucketCriteria(block: S3BucketCriteriaForJob.DslBuilder.() -> kotlin.Unit) {
            this.bucketCriteria = S3BucketCriteriaForJob.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.Scoping] inside the given [block]
         */
        fun scoping(block: Scoping.DslBuilder.() -> kotlin.Unit) {
            this.scoping = Scoping.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var bucketCriteria: S3BucketCriteriaForJob? = null
        override var bucketDefinitions: List<S3BucketDefinitionForJob>? = null
        override var scoping: Scoping? = null

        constructor(x: S3JobDefinition) : this() {
            this.bucketCriteria = x.bucketCriteria
            this.bucketDefinitions = x.bucketDefinitions
            this.scoping = x.scoping
        }

        override fun build(): S3JobDefinition = S3JobDefinition(this)
        override fun bucketCriteria(bucketCriteria: S3BucketCriteriaForJob): FluentBuilder = apply { this.bucketCriteria = bucketCriteria }
        override fun bucketDefinitions(bucketDefinitions: List<S3BucketDefinitionForJob>): FluentBuilder = apply { this.bucketDefinitions = bucketDefinitions }
        override fun scoping(scoping: Scoping): FluentBuilder = apply { this.scoping = scoping }
    }
}
