// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information about the S3 object that a finding applies to.
 */
class S3Object private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the bucket that contains the object.
     */
    val bucketArn: String? = builder.bucketArn
    /**
     * The entity tag (ETag) that identifies the affected version of the object. If the object was overwritten or changed after Amazon Macie produced the finding, this value might be different from the current ETag for the object.
     */
    val eTag: String? = builder.eTag
    /**
     * The file name extension of the object. If the object doesn't have a file name extension, this value is "".
     */
    val extension: String? = builder.extension
    /**
     * The full key (name) that's assigned to the object.
     */
    val key: String? = builder.key
    /**
     * The date and time, in UTC and extended ISO 8601 format, when the object was last modified.
     */
    val lastModified: Instant? = builder.lastModified
    /**
     * The path to the object, including the full key (name).
     */
    val path: String? = builder.path
    /**
     * Specifies whether the object is publicly accessible due to the combination of permissions settings that apply to the object.
     */
    val publicAccess: Boolean? = builder.publicAccess
    /**
     * The type of server-side encryption that's used to encrypt the object.
     */
    val serverSideEncryption: ServerSideEncryption? = builder.serverSideEncryption
    /**
     * The total storage size, in bytes, of the object.
     */
    val size: Long? = builder.size
    /**
     * The storage class of the object.
     */
    val storageClass: StorageClass? = builder.storageClass
    /**
     * The tags that are associated with the object.
     */
    val tags: List<KeyValuePair>? = builder.tags
    /**
     * The identifier for the affected version of the object.
     */
    val versionId: String? = builder.versionId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): S3Object = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("S3Object(")
        append("bucketArn=$bucketArn,")
        append("eTag=$eTag,")
        append("extension=$extension,")
        append("key=$key,")
        append("lastModified=$lastModified,")
        append("path=$path,")
        append("publicAccess=$publicAccess,")
        append("serverSideEncryption=$serverSideEncryption,")
        append("size=$size,")
        append("storageClass=$storageClass,")
        append("tags=$tags,")
        append("versionId=$versionId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketArn?.hashCode() ?: 0
        result = 31 * result + (eTag?.hashCode() ?: 0)
        result = 31 * result + (extension?.hashCode() ?: 0)
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (lastModified?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (publicAccess?.hashCode() ?: 0)
        result = 31 * result + (serverSideEncryption?.hashCode() ?: 0)
        result = 31 * result + (size?.hashCode() ?: 0)
        result = 31 * result + (storageClass?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (versionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as S3Object

        if (bucketArn != other.bucketArn) return false
        if (eTag != other.eTag) return false
        if (extension != other.extension) return false
        if (key != other.key) return false
        if (lastModified != other.lastModified) return false
        if (path != other.path) return false
        if (publicAccess != other.publicAccess) return false
        if (serverSideEncryption != other.serverSideEncryption) return false
        if (size != other.size) return false
        if (storageClass != other.storageClass) return false
        if (tags != other.tags) return false
        if (versionId != other.versionId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): S3Object = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): S3Object
        /**
         * The Amazon Resource Name (ARN) of the bucket that contains the object.
         */
        fun bucketArn(bucketArn: String): FluentBuilder
        /**
         * The entity tag (ETag) that identifies the affected version of the object. If the object was overwritten or changed after Amazon Macie produced the finding, this value might be different from the current ETag for the object.
         */
        fun eTag(eTag: String): FluentBuilder
        /**
         * The file name extension of the object. If the object doesn't have a file name extension, this value is "".
         */
        fun extension(extension: String): FluentBuilder
        /**
         * The full key (name) that's assigned to the object.
         */
        fun key(key: String): FluentBuilder
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the object was last modified.
         */
        fun lastModified(lastModified: Instant): FluentBuilder
        /**
         * The path to the object, including the full key (name).
         */
        fun path(path: String): FluentBuilder
        /**
         * Specifies whether the object is publicly accessible due to the combination of permissions settings that apply to the object.
         */
        fun publicAccess(publicAccess: Boolean): FluentBuilder
        /**
         * The type of server-side encryption that's used to encrypt the object.
         */
        fun serverSideEncryption(serverSideEncryption: ServerSideEncryption): FluentBuilder
        /**
         * The total storage size, in bytes, of the object.
         */
        fun size(size: Long): FluentBuilder
        /**
         * The storage class of the object.
         */
        fun storageClass(storageClass: StorageClass): FluentBuilder
        /**
         * The tags that are associated with the object.
         */
        fun tags(tags: List<KeyValuePair>): FluentBuilder
        /**
         * The identifier for the affected version of the object.
         */
        fun versionId(versionId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the bucket that contains the object.
         */
        var bucketArn: String?
        /**
         * The entity tag (ETag) that identifies the affected version of the object. If the object was overwritten or changed after Amazon Macie produced the finding, this value might be different from the current ETag for the object.
         */
        var eTag: String?
        /**
         * The file name extension of the object. If the object doesn't have a file name extension, this value is "".
         */
        var extension: String?
        /**
         * The full key (name) that's assigned to the object.
         */
        var key: String?
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the object was last modified.
         */
        var lastModified: Instant?
        /**
         * The path to the object, including the full key (name).
         */
        var path: String?
        /**
         * Specifies whether the object is publicly accessible due to the combination of permissions settings that apply to the object.
         */
        var publicAccess: Boolean?
        /**
         * The type of server-side encryption that's used to encrypt the object.
         */
        var serverSideEncryption: ServerSideEncryption?
        /**
         * The total storage size, in bytes, of the object.
         */
        var size: Long?
        /**
         * The storage class of the object.
         */
        var storageClass: StorageClass?
        /**
         * The tags that are associated with the object.
         */
        var tags: List<KeyValuePair>?
        /**
         * The identifier for the affected version of the object.
         */
        var versionId: String?

        fun build(): S3Object
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.ServerSideEncryption] inside the given [block]
         */
        fun serverSideEncryption(block: ServerSideEncryption.DslBuilder.() -> kotlin.Unit) {
            this.serverSideEncryption = ServerSideEncryption.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var bucketArn: String? = null
        override var eTag: String? = null
        override var extension: String? = null
        override var key: String? = null
        override var lastModified: Instant? = null
        override var path: String? = null
        override var publicAccess: Boolean? = null
        override var serverSideEncryption: ServerSideEncryption? = null
        override var size: Long? = null
        override var storageClass: StorageClass? = null
        override var tags: List<KeyValuePair>? = null
        override var versionId: String? = null

        constructor(x: S3Object) : this() {
            this.bucketArn = x.bucketArn
            this.eTag = x.eTag
            this.extension = x.extension
            this.key = x.key
            this.lastModified = x.lastModified
            this.path = x.path
            this.publicAccess = x.publicAccess
            this.serverSideEncryption = x.serverSideEncryption
            this.size = x.size
            this.storageClass = x.storageClass
            this.tags = x.tags
            this.versionId = x.versionId
        }

        override fun build(): S3Object = S3Object(this)
        override fun bucketArn(bucketArn: String): FluentBuilder = apply { this.bucketArn = bucketArn }
        override fun eTag(eTag: String): FluentBuilder = apply { this.eTag = eTag }
        override fun extension(extension: String): FluentBuilder = apply { this.extension = extension }
        override fun key(key: String): FluentBuilder = apply { this.key = key }
        override fun lastModified(lastModified: Instant): FluentBuilder = apply { this.lastModified = lastModified }
        override fun path(path: String): FluentBuilder = apply { this.path = path }
        override fun publicAccess(publicAccess: Boolean): FluentBuilder = apply { this.publicAccess = publicAccess }
        override fun serverSideEncryption(serverSideEncryption: ServerSideEncryption): FluentBuilder = apply { this.serverSideEncryption = serverSideEncryption }
        override fun size(size: Long): FluentBuilder = apply { this.size = size }
        override fun storageClass(storageClass: StorageClass): FluentBuilder = apply { this.storageClass = storageClass }
        override fun tags(tags: List<KeyValuePair>): FluentBuilder = apply { this.tags = tags }
        override fun versionId(versionId: String): FluentBuilder = apply { this.versionId = versionId }
    }
}
