// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



class SearchResourcesRequest private constructor(builder: BuilderImpl) {
    /**
     * The filter conditions that determine which S3 buckets to include or exclude from the query results.
     */
    val bucketCriteria: SearchResourcesBucketCriteria? = builder.bucketCriteria
    /**
     * The maximum number of items to include in each page of the response. The default value is 50.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The nextToken string that specifies which page of results to return in a paginated response.
     */
    val nextToken: String? = builder.nextToken
    /**
     * The criteria to use to sort the results.
     */
    val sortCriteria: SearchResourcesSortCriteria? = builder.sortCriteria

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SearchResourcesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SearchResourcesRequest(")
        append("bucketCriteria=$bucketCriteria,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("sortCriteria=$sortCriteria)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketCriteria?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (sortCriteria?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SearchResourcesRequest

        if (bucketCriteria != other.bucketCriteria) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (sortCriteria != other.sortCriteria) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SearchResourcesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SearchResourcesRequest
        /**
         * The filter conditions that determine which S3 buckets to include or exclude from the query results.
         */
        fun bucketCriteria(bucketCriteria: SearchResourcesBucketCriteria): FluentBuilder
        /**
         * The maximum number of items to include in each page of the response. The default value is 50.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The nextToken string that specifies which page of results to return in a paginated response.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The criteria to use to sort the results.
         */
        fun sortCriteria(sortCriteria: SearchResourcesSortCriteria): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The filter conditions that determine which S3 buckets to include or exclude from the query results.
         */
        var bucketCriteria: SearchResourcesBucketCriteria?
        /**
         * The maximum number of items to include in each page of the response. The default value is 50.
         */
        var maxResults: Int?
        /**
         * The nextToken string that specifies which page of results to return in a paginated response.
         */
        var nextToken: String?
        /**
         * The criteria to use to sort the results.
         */
        var sortCriteria: SearchResourcesSortCriteria?

        fun build(): SearchResourcesRequest
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.SearchResourcesBucketCriteria] inside the given [block]
         */
        fun bucketCriteria(block: SearchResourcesBucketCriteria.DslBuilder.() -> kotlin.Unit) {
            this.bucketCriteria = SearchResourcesBucketCriteria.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.SearchResourcesSortCriteria] inside the given [block]
         */
        fun sortCriteria(block: SearchResourcesSortCriteria.DslBuilder.() -> kotlin.Unit) {
            this.sortCriteria = SearchResourcesSortCriteria.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var bucketCriteria: SearchResourcesBucketCriteria? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var sortCriteria: SearchResourcesSortCriteria? = null

        constructor(x: SearchResourcesRequest) : this() {
            this.bucketCriteria = x.bucketCriteria
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.sortCriteria = x.sortCriteria
        }

        override fun build(): SearchResourcesRequest = SearchResourcesRequest(this)
        override fun bucketCriteria(bucketCriteria: SearchResourcesBucketCriteria): FluentBuilder = apply { this.bucketCriteria = bucketCriteria }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun sortCriteria(sortCriteria: SearchResourcesSortCriteria): FluentBuilder = apply { this.sortCriteria = sortCriteria }
    }
}
