// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Specifies a property-based filter condition that determines which Amazon Web Services resources are included or excluded from the query results.
 */
class SearchResourcesSimpleCriterion private constructor(builder: BuilderImpl) {
    /**
     * The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).
     */
    val comparator: SearchResourcesComparator? = builder.comparator
    /**
     * The property to use in the condition.
     */
    val key: SearchResourcesSimpleCriterionKey? = builder.key
    /**
     * An array that lists one or more values to use in the condition. If you specify multiple values, Amazon Macie uses OR logic to join the values. Valid values for each supported property (key) are: ACCOUNT_ID - A string that represents the unique identifier for the Amazon Web Services account that owns the resource. S3_BUCKET_EFFECTIVE_PERMISSION - A string that represents an enumerated value that Macie defines for the <a href="https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketpublicaccess-effectivepermission">BucketPublicAccess.effectivePermission property of an S3 bucket. S3_BUCKET_NAME - A string that represents the name of an S3 bucket. S3_BUCKET_SHARED_ACCESS - A string that represents an enumerated value that Macie defines for the <a href="https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketmetadata-sharedaccess">BucketMetadata.sharedAccess property of an S3 bucket. Values are case sensitive. Also, Macie doesn't support use of partial values or wildcard characters in values.
     */
    val values: List<String>? = builder.values

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SearchResourcesSimpleCriterion = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SearchResourcesSimpleCriterion(")
        append("comparator=$comparator,")
        append("key=$key,")
        append("values=$values)")
    }

    override fun hashCode(): kotlin.Int {
        var result = comparator?.hashCode() ?: 0
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SearchResourcesSimpleCriterion

        if (comparator != other.comparator) return false
        if (key != other.key) return false
        if (values != other.values) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SearchResourcesSimpleCriterion = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SearchResourcesSimpleCriterion
        /**
         * The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).
         */
        fun comparator(comparator: SearchResourcesComparator): FluentBuilder
        /**
         * The property to use in the condition.
         */
        fun key(key: SearchResourcesSimpleCriterionKey): FluentBuilder
        /**
         * An array that lists one or more values to use in the condition. If you specify multiple values, Amazon Macie uses OR logic to join the values. Valid values for each supported property (key) are: ACCOUNT_ID - A string that represents the unique identifier for the Amazon Web Services account that owns the resource. S3_BUCKET_EFFECTIVE_PERMISSION - A string that represents an enumerated value that Macie defines for the <a href="https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketpublicaccess-effectivepermission">BucketPublicAccess.effectivePermission property of an S3 bucket. S3_BUCKET_NAME - A string that represents the name of an S3 bucket. S3_BUCKET_SHARED_ACCESS - A string that represents an enumerated value that Macie defines for the <a href="https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketmetadata-sharedaccess">BucketMetadata.sharedAccess property of an S3 bucket. Values are case sensitive. Also, Macie doesn't support use of partial values or wildcard characters in values.
         */
        fun values(values: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).
         */
        var comparator: SearchResourcesComparator?
        /**
         * The property to use in the condition.
         */
        var key: SearchResourcesSimpleCriterionKey?
        /**
         * An array that lists one or more values to use in the condition. If you specify multiple values, Amazon Macie uses OR logic to join the values. Valid values for each supported property (key) are: ACCOUNT_ID - A string that represents the unique identifier for the Amazon Web Services account that owns the resource. S3_BUCKET_EFFECTIVE_PERMISSION - A string that represents an enumerated value that Macie defines for the <a href="https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketpublicaccess-effectivepermission">BucketPublicAccess.effectivePermission property of an S3 bucket. S3_BUCKET_NAME - A string that represents the name of an S3 bucket. S3_BUCKET_SHARED_ACCESS - A string that represents an enumerated value that Macie defines for the <a href="https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketmetadata-sharedaccess">BucketMetadata.sharedAccess property of an S3 bucket. Values are case sensitive. Also, Macie doesn't support use of partial values or wildcard characters in values.
         */
        var values: List<String>?

        fun build(): SearchResourcesSimpleCriterion
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var comparator: SearchResourcesComparator? = null
        override var key: SearchResourcesSimpleCriterionKey? = null
        override var values: List<String>? = null

        constructor(x: SearchResourcesSimpleCriterion) : this() {
            this.comparator = x.comparator
            this.key = x.key
            this.values = x.values
        }

        override fun build(): SearchResourcesSimpleCriterion = SearchResourcesSimpleCriterion(this)
        override fun comparator(comparator: SearchResourcesComparator): FluentBuilder = apply { this.comparator = comparator }
        override fun key(key: SearchResourcesSimpleCriterionKey): FluentBuilder = apply { this.key = key }
        override fun values(values: List<String>): FluentBuilder = apply { this.values = values }
    }
}
