// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Specifies configuration settings that determine which findings are published to Security Hub automatically. For information about how Macie publishes findings to Security Hub, see <a href="https://docs.aws.amazon.com/macie/latest/user/securityhub-integration.html">Amazon Macie integration with Security Hub in the Amazon Macie User Guide.
 */
class SecurityHubConfiguration private constructor(builder: BuilderImpl) {
    /**
     * Specifies whether to publish sensitive data findings to Security Hub. If you set this value to true, Amazon Macie automatically publishes all sensitive data findings that weren't suppressed by a findings filter. The default value is false.
     */
    val publishClassificationFindings: Boolean? = builder.publishClassificationFindings
    /**
     * Specifies whether to publish policy findings to Security Hub. If you set this value to true, Amazon Macie automatically publishes all new and updated policy findings that weren't suppressed by a findings filter. The default value is true.
     */
    val publishPolicyFindings: Boolean? = builder.publishPolicyFindings

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SecurityHubConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SecurityHubConfiguration(")
        append("publishClassificationFindings=$publishClassificationFindings,")
        append("publishPolicyFindings=$publishPolicyFindings)")
    }

    override fun hashCode(): kotlin.Int {
        var result = publishClassificationFindings?.hashCode() ?: 0
        result = 31 * result + (publishPolicyFindings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SecurityHubConfiguration

        if (publishClassificationFindings != other.publishClassificationFindings) return false
        if (publishPolicyFindings != other.publishPolicyFindings) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SecurityHubConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SecurityHubConfiguration
        /**
         * Specifies whether to publish sensitive data findings to Security Hub. If you set this value to true, Amazon Macie automatically publishes all sensitive data findings that weren't suppressed by a findings filter. The default value is false.
         */
        fun publishClassificationFindings(publishClassificationFindings: Boolean): FluentBuilder
        /**
         * Specifies whether to publish policy findings to Security Hub. If you set this value to true, Amazon Macie automatically publishes all new and updated policy findings that weren't suppressed by a findings filter. The default value is true.
         */
        fun publishPolicyFindings(publishPolicyFindings: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specifies whether to publish sensitive data findings to Security Hub. If you set this value to true, Amazon Macie automatically publishes all sensitive data findings that weren't suppressed by a findings filter. The default value is false.
         */
        var publishClassificationFindings: Boolean?
        /**
         * Specifies whether to publish policy findings to Security Hub. If you set this value to true, Amazon Macie automatically publishes all new and updated policy findings that weren't suppressed by a findings filter. The default value is true.
         */
        var publishPolicyFindings: Boolean?

        fun build(): SecurityHubConfiguration
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var publishClassificationFindings: Boolean? = null
        override var publishPolicyFindings: Boolean? = null

        constructor(x: SecurityHubConfiguration) : this() {
            this.publishClassificationFindings = x.publishClassificationFindings
            this.publishPolicyFindings = x.publishPolicyFindings
        }

        override fun build(): SecurityHubConfiguration = SecurityHubConfiguration(this)
        override fun publishClassificationFindings(publishClassificationFindings: Boolean): FluentBuilder = apply { this.publishClassificationFindings = publishClassificationFindings }
        override fun publishPolicyFindings(publishPolicyFindings: Boolean): FluentBuilder = apply { this.publishPolicyFindings = publishPolicyFindings }
    }
}
