// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about the category, types, and occurrences of sensitive data that produced a sensitive data finding.
 */
class SensitiveDataItem private constructor(builder: BuilderImpl) {
    /**
     * The category of sensitive data that was detected. For example: CREDENTIALS, for credentials data such as private keys or Amazon Web Services secret keys; FINANCIAL_INFORMATION, for financial data such as credit card numbers; or, PERSONAL_INFORMATION, for personal health information, such as health insurance identification numbers, or personally identifiable information, such as driver's license identification numbers.
     */
    val category: SensitiveDataItemCategory? = builder.category
    /**
     * An array of objects, one for each type of sensitive data that was detected. Each object reports the number of occurrences of a specific type of sensitive data that was detected, and the location of up to 15 of those occurrences.
     */
    val detections: List<DefaultDetection>? = builder.detections
    /**
     * The total number of occurrences of the sensitive data that was detected.
     */
    val totalCount: Long? = builder.totalCount

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SensitiveDataItem = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SensitiveDataItem(")
        append("category=$category,")
        append("detections=$detections,")
        append("totalCount=$totalCount)")
    }

    override fun hashCode(): kotlin.Int {
        var result = category?.hashCode() ?: 0
        result = 31 * result + (detections?.hashCode() ?: 0)
        result = 31 * result + (totalCount?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SensitiveDataItem

        if (category != other.category) return false
        if (detections != other.detections) return false
        if (totalCount != other.totalCount) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SensitiveDataItem = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SensitiveDataItem
        /**
         * The category of sensitive data that was detected. For example: CREDENTIALS, for credentials data such as private keys or Amazon Web Services secret keys; FINANCIAL_INFORMATION, for financial data such as credit card numbers; or, PERSONAL_INFORMATION, for personal health information, such as health insurance identification numbers, or personally identifiable information, such as driver's license identification numbers.
         */
        fun category(category: SensitiveDataItemCategory): FluentBuilder
        /**
         * An array of objects, one for each type of sensitive data that was detected. Each object reports the number of occurrences of a specific type of sensitive data that was detected, and the location of up to 15 of those occurrences.
         */
        fun detections(detections: List<DefaultDetection>): FluentBuilder
        /**
         * The total number of occurrences of the sensitive data that was detected.
         */
        fun totalCount(totalCount: Long): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The category of sensitive data that was detected. For example: CREDENTIALS, for credentials data such as private keys or Amazon Web Services secret keys; FINANCIAL_INFORMATION, for financial data such as credit card numbers; or, PERSONAL_INFORMATION, for personal health information, such as health insurance identification numbers, or personally identifiable information, such as driver's license identification numbers.
         */
        var category: SensitiveDataItemCategory?
        /**
         * An array of objects, one for each type of sensitive data that was detected. Each object reports the number of occurrences of a specific type of sensitive data that was detected, and the location of up to 15 of those occurrences.
         */
        var detections: List<DefaultDetection>?
        /**
         * The total number of occurrences of the sensitive data that was detected.
         */
        var totalCount: Long?

        fun build(): SensitiveDataItem
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var category: SensitiveDataItemCategory? = null
        override var detections: List<DefaultDetection>? = null
        override var totalCount: Long? = null

        constructor(x: SensitiveDataItem) : this() {
            this.category = x.category
            this.detections = x.detections
            this.totalCount = x.totalCount
        }

        override fun build(): SensitiveDataItem = SensitiveDataItem(this)
        override fun category(category: SensitiveDataItemCategory): FluentBuilder = apply { this.category = category }
        override fun detections(detections: List<DefaultDetection>): FluentBuilder = apply { this.detections = detections }
        override fun totalCount(totalCount: Long): FluentBuilder = apply { this.totalCount = totalCount }
    }
}
