// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about the server-side encryption settings for an S3 bucket or S3 object.
 */
class ServerSideEncryption private constructor(builder: BuilderImpl) {
    /**
     * The server-side encryption algorithm that's used when storing data in the bucket or object. If default encryption is disabled for the bucket or the object isn't encrypted using server-side encryption, this value is NONE.
     */
    val encryptionType: EncryptionType? = builder.encryptionType
    /**
     * The Amazon Resource Name (ARN) or unique identifier (key ID) for the Key Management Service (KMS) customer master key (CMK) that's used to encrypt data in the bucket or the object. If an KMS CMK isn't used, this value is null.
     */
    val kmsMasterKeyId: String? = builder.kmsMasterKeyId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ServerSideEncryption = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ServerSideEncryption(")
        append("encryptionType=$encryptionType,")
        append("kmsMasterKeyId=$kmsMasterKeyId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = encryptionType?.hashCode() ?: 0
        result = 31 * result + (kmsMasterKeyId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ServerSideEncryption

        if (encryptionType != other.encryptionType) return false
        if (kmsMasterKeyId != other.kmsMasterKeyId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ServerSideEncryption = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ServerSideEncryption
        /**
         * The server-side encryption algorithm that's used when storing data in the bucket or object. If default encryption is disabled for the bucket or the object isn't encrypted using server-side encryption, this value is NONE.
         */
        fun encryptionType(encryptionType: EncryptionType): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) or unique identifier (key ID) for the Key Management Service (KMS) customer master key (CMK) that's used to encrypt data in the bucket or the object. If an KMS CMK isn't used, this value is null.
         */
        fun kmsMasterKeyId(kmsMasterKeyId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The server-side encryption algorithm that's used when storing data in the bucket or object. If default encryption is disabled for the bucket or the object isn't encrypted using server-side encryption, this value is NONE.
         */
        var encryptionType: EncryptionType?
        /**
         * The Amazon Resource Name (ARN) or unique identifier (key ID) for the Key Management Service (KMS) customer master key (CMK) that's used to encrypt data in the bucket or the object. If an KMS CMK isn't used, this value is null.
         */
        var kmsMasterKeyId: String?

        fun build(): ServerSideEncryption
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var encryptionType: EncryptionType? = null
        override var kmsMasterKeyId: String? = null

        constructor(x: ServerSideEncryption) : this() {
            this.encryptionType = x.encryptionType
            this.kmsMasterKeyId = x.kmsMasterKeyId
        }

        override fun build(): ServerSideEncryption = ServerSideEncryption(this)
        override fun encryptionType(encryptionType: EncryptionType): FluentBuilder = apply { this.encryptionType = encryptionType }
        override fun kmsMasterKeyId(kmsMasterKeyId: String): FluentBuilder = apply { this.kmsMasterKeyId = kmsMasterKeyId }
    }
}
