// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information about the context in which temporary security credentials were issued to an entity.
 */
class SessionContextAttributes private constructor(builder: BuilderImpl) {
    /**
     * The date and time, in UTC and ISO 8601 format, when the credentials were issued.
     */
    val creationDate: Instant? = builder.creationDate
    /**
     * Specifies whether the credentials were authenticated with a multi-factor authentication (MFA) device.
     */
    val mfaAuthenticated: Boolean? = builder.mfaAuthenticated

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SessionContextAttributes = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SessionContextAttributes(")
        append("creationDate=$creationDate,")
        append("mfaAuthenticated=$mfaAuthenticated)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDate?.hashCode() ?: 0
        result = 31 * result + (mfaAuthenticated?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SessionContextAttributes

        if (creationDate != other.creationDate) return false
        if (mfaAuthenticated != other.mfaAuthenticated) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SessionContextAttributes = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SessionContextAttributes
        /**
         * The date and time, in UTC and ISO 8601 format, when the credentials were issued.
         */
        fun creationDate(creationDate: Instant): FluentBuilder
        /**
         * Specifies whether the credentials were authenticated with a multi-factor authentication (MFA) device.
         */
        fun mfaAuthenticated(mfaAuthenticated: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The date and time, in UTC and ISO 8601 format, when the credentials were issued.
         */
        var creationDate: Instant?
        /**
         * Specifies whether the credentials were authenticated with a multi-factor authentication (MFA) device.
         */
        var mfaAuthenticated: Boolean?

        fun build(): SessionContextAttributes
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var creationDate: Instant? = null
        override var mfaAuthenticated: Boolean? = null

        constructor(x: SessionContextAttributes) : this() {
            this.creationDate = x.creationDate
            this.mfaAuthenticated = x.mfaAuthenticated
        }

        override fun build(): SessionContextAttributes = SessionContextAttributes(this)
        override fun creationDate(creationDate: Instant): FluentBuilder = apply { this.creationDate = creationDate }
        override fun mfaAuthenticated(mfaAuthenticated: Boolean): FluentBuilder = apply { this.mfaAuthenticated = mfaAuthenticated }
    }
}
