// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about the source and type of temporary security credentials that were issued to an entity.
 */
class SessionIssuer private constructor(builder: BuilderImpl) {
    /**
     * The unique identifier for the Amazon Web Services account that owns the entity that was used to get the credentials.
     */
    val accountId: String? = builder.accountId
    /**
     * The Amazon Resource Name (ARN) of the source account, IAM user, or role that was used to get the credentials.
     */
    val arn: String? = builder.arn
    /**
     * The unique identifier for the entity that was used to get the credentials.
     */
    val principalId: String? = builder.principalId
    /**
     * The source of the temporary security credentials, such as Root, IAMUser, or Role.
     */
    val type: String? = builder.type
    /**
     * The name or alias of the user or role that issued the session. This value is null if the credentials were obtained from a root account that doesn't have an alias.
     */
    val userName: String? = builder.userName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SessionIssuer = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SessionIssuer(")
        append("accountId=$accountId,")
        append("arn=$arn,")
        append("principalId=$principalId,")
        append("type=$type,")
        append("userName=$userName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (principalId?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SessionIssuer

        if (accountId != other.accountId) return false
        if (arn != other.arn) return false
        if (principalId != other.principalId) return false
        if (type != other.type) return false
        if (userName != other.userName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SessionIssuer = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SessionIssuer
        /**
         * The unique identifier for the Amazon Web Services account that owns the entity that was used to get the credentials.
         */
        fun accountId(accountId: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the source account, IAM user, or role that was used to get the credentials.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The unique identifier for the entity that was used to get the credentials.
         */
        fun principalId(principalId: String): FluentBuilder
        /**
         * The source of the temporary security credentials, such as Root, IAMUser, or Role.
         */
        fun type(type: String): FluentBuilder
        /**
         * The name or alias of the user or role that issued the session. This value is null if the credentials were obtained from a root account that doesn't have an alias.
         */
        fun userName(userName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The unique identifier for the Amazon Web Services account that owns the entity that was used to get the credentials.
         */
        var accountId: String?
        /**
         * The Amazon Resource Name (ARN) of the source account, IAM user, or role that was used to get the credentials.
         */
        var arn: String?
        /**
         * The unique identifier for the entity that was used to get the credentials.
         */
        var principalId: String?
        /**
         * The source of the temporary security credentials, such as Root, IAMUser, or Role.
         */
        var type: String?
        /**
         * The name or alias of the user or role that issued the session. This value is null if the credentials were obtained from a root account that doesn't have an alias.
         */
        var userName: String?

        fun build(): SessionIssuer
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accountId: String? = null
        override var arn: String? = null
        override var principalId: String? = null
        override var type: String? = null
        override var userName: String? = null

        constructor(x: SessionIssuer) : this() {
            this.accountId = x.accountId
            this.arn = x.arn
            this.principalId = x.principalId
            this.type = x.type
            this.userName = x.userName
        }

        override fun build(): SessionIssuer = SessionIssuer(this)
        override fun accountId(accountId: String): FluentBuilder = apply { this.accountId = accountId }
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun principalId(principalId: String): FluentBuilder = apply { this.principalId = principalId }
        override fun type(type: String): FluentBuilder = apply { this.type = type }
        override fun userName(userName: String): FluentBuilder = apply { this.userName = userName }
    }
}
