// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Specifies a tag-based condition that determines whether an S3 object is included or excluded from a classification job.
 */
class TagScopeTerm private constructor(builder: BuilderImpl) {
    /**
     * The operator to use in the condition. Valid values are EQ (equals) or NE (not equals).
     */
    val comparator: JobComparator? = builder.comparator
    /**
     * The object property to use in the condition. The only valid value is TAG.
     */
    val key: String? = builder.key
    /**
     * The tag keys or tag key and value pairs to use in the condition. To specify only tag keys in a condition, specify the keys in this array and set the value for each associated tag value to an empty string.
     */
    val tagValues: List<TagValuePair>? = builder.tagValues
    /**
     * The type of object to apply the condition to.
     */
    val target: TagTarget? = builder.target

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TagScopeTerm = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TagScopeTerm(")
        append("comparator=$comparator,")
        append("key=$key,")
        append("tagValues=$tagValues,")
        append("target=$target)")
    }

    override fun hashCode(): kotlin.Int {
        var result = comparator?.hashCode() ?: 0
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (tagValues?.hashCode() ?: 0)
        result = 31 * result + (target?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TagScopeTerm

        if (comparator != other.comparator) return false
        if (key != other.key) return false
        if (tagValues != other.tagValues) return false
        if (target != other.target) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TagScopeTerm = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TagScopeTerm
        /**
         * The operator to use in the condition. Valid values are EQ (equals) or NE (not equals).
         */
        fun comparator(comparator: JobComparator): FluentBuilder
        /**
         * The object property to use in the condition. The only valid value is TAG.
         */
        fun key(key: String): FluentBuilder
        /**
         * The tag keys or tag key and value pairs to use in the condition. To specify only tag keys in a condition, specify the keys in this array and set the value for each associated tag value to an empty string.
         */
        fun tagValues(tagValues: List<TagValuePair>): FluentBuilder
        /**
         * The type of object to apply the condition to.
         */
        fun target(target: TagTarget): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The operator to use in the condition. Valid values are EQ (equals) or NE (not equals).
         */
        var comparator: JobComparator?
        /**
         * The object property to use in the condition. The only valid value is TAG.
         */
        var key: String?
        /**
         * The tag keys or tag key and value pairs to use in the condition. To specify only tag keys in a condition, specify the keys in this array and set the value for each associated tag value to an empty string.
         */
        var tagValues: List<TagValuePair>?
        /**
         * The type of object to apply the condition to.
         */
        var target: TagTarget?

        fun build(): TagScopeTerm
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var comparator: JobComparator? = null
        override var key: String? = null
        override var tagValues: List<TagValuePair>? = null
        override var target: TagTarget? = null

        constructor(x: TagScopeTerm) : this() {
            this.comparator = x.comparator
            this.key = x.key
            this.tagValues = x.tagValues
            this.target = x.target
        }

        override fun build(): TagScopeTerm = TagScopeTerm(this)
        override fun comparator(comparator: JobComparator): FluentBuilder = apply { this.comparator = comparator }
        override fun key(key: String): FluentBuilder = apply { this.key = key }
        override fun tagValues(tagValues: List<TagValuePair>): FluentBuilder = apply { this.tagValues = tagValues }
        override fun target(target: TagTarget): FluentBuilder = apply { this.target = target }
    }
}
