// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Specifies a tag key or tag key and value pair to use in a tag-based condition that determines whether an S3 object is included or excluded from a classification job. Tag keys and values are case sensitive. Also, Amazon Macie doesn't support use of partial values or wildcard characters in tag-based conditions.
 */
class TagValuePair private constructor(builder: BuilderImpl) {
    /**
     * The value for the tag key to use in the condition.
     */
    val key: String? = builder.key
    /**
     * The tag value, associated with the specified tag key (key), to use in the condition. To specify only a tag key for a condition, specify the tag key for the key property and set this value to an empty string.
     */
    val value: String? = builder.value

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TagValuePair = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TagValuePair(")
        append("key=$key,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = key?.hashCode() ?: 0
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TagValuePair

        if (key != other.key) return false
        if (value != other.value) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TagValuePair = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TagValuePair
        /**
         * The value for the tag key to use in the condition.
         */
        fun key(key: String): FluentBuilder
        /**
         * The tag value, associated with the specified tag key (key), to use in the condition. To specify only a tag key for a condition, specify the tag key for the key property and set this value to an empty string.
         */
        fun value(value: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The value for the tag key to use in the condition.
         */
        var key: String?
        /**
         * The tag value, associated with the specified tag key (key), to use in the condition. To specify only a tag key for a condition, specify the tag key for the key property and set this value to an empty string.
         */
        var value: String?

        fun build(): TagValuePair
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var key: String? = null
        override var value: String? = null

        constructor(x: TagValuePair) : this() {
            this.key = x.key
            this.value = x.value
        }

        override fun build(): TagValuePair = TagValuePair(this)
        override fun key(key: String): FluentBuilder = apply { this.key = key }
        override fun value(value: String): FluentBuilder = apply { this.value = value }
    }
}
