// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about an account-related request that hasn't been processed.
 */
class UnprocessedAccount private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Web Services account ID for the account that the request applies to.
     */
    val accountId: String? = builder.accountId
    /**
     * The source of the issue or delay in processing the request.
     */
    val errorCode: ErrorCode? = builder.errorCode
    /**
     * The reason why the request hasn't been processed.
     */
    val errorMessage: String? = builder.errorMessage

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UnprocessedAccount = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UnprocessedAccount(")
        append("accountId=$accountId,")
        append("errorCode=$errorCode,")
        append("errorMessage=$errorMessage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (errorCode?.hashCode() ?: 0)
        result = 31 * result + (errorMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UnprocessedAccount

        if (accountId != other.accountId) return false
        if (errorCode != other.errorCode) return false
        if (errorMessage != other.errorMessage) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UnprocessedAccount = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UnprocessedAccount
        /**
         * The Amazon Web Services account ID for the account that the request applies to.
         */
        fun accountId(accountId: String): FluentBuilder
        /**
         * The source of the issue or delay in processing the request.
         */
        fun errorCode(errorCode: ErrorCode): FluentBuilder
        /**
         * The reason why the request hasn't been processed.
         */
        fun errorMessage(errorMessage: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Web Services account ID for the account that the request applies to.
         */
        var accountId: String?
        /**
         * The source of the issue or delay in processing the request.
         */
        var errorCode: ErrorCode?
        /**
         * The reason why the request hasn't been processed.
         */
        var errorMessage: String?

        fun build(): UnprocessedAccount
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accountId: String? = null
        override var errorCode: ErrorCode? = null
        override var errorMessage: String? = null

        constructor(x: UnprocessedAccount) : this() {
            this.accountId = x.accountId
            this.errorCode = x.errorCode
            this.errorMessage = x.errorMessage
        }

        override fun build(): UnprocessedAccount = UnprocessedAccount(this)
        override fun accountId(accountId: String): FluentBuilder = apply { this.accountId = accountId }
        override fun errorCode(errorCode: ErrorCode): FluentBuilder = apply { this.errorCode = errorCode }
        override fun errorMessage(errorMessage: String): FluentBuilder = apply { this.errorMessage = errorMessage }
    }
}
